///////////////////////////////////////////////////////////////////////////////
//
// This program is part of the Open Inventor Medical example set.
//
// Open Inventor customers may use this source code to create or enhance
// Open Inventor-based applications.
//
// The medical utility classes are provided as a prebuilt library named
// "fei.inventor.Medical", that can be used directly in an Open Inventor
// application. The classes in the prebuilt library are documented and
// supported by Thermo Fisher Scientific. These classes are also provided as source code.
//
// Please see $OIVHOME/include/Medical/InventorMedical.h for the full text.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef _SO_OFFSCREEN_VOLUME_RENDER_CUSTOM_H_
#define _SO_OFFSCREEN_VOLUME_RENDER_CUSTOM_H_

#include <VolumeViz/nodes/SoOffscreenVolumeRender.h>

class SoOffscreenVolumeRenderCustom : public SoOffscreenVolumeRender
{
  SO_NODE_HEADER(SoOffscreenVolumeRenderCustom);

public:

  /** This field control iterative subox returned by getNextSubBox calls.
   * boxSize is subdivided according to this field. 
   * Default is 0 (only one box is generated).
   */
  SoSFVec3i32 boxSubdivision;

  /** Default constructor */
  SoOffscreenVolumeRenderCustom();

  /** Set the SoVolumeData where voxels are copied */
  void setResultVolumeData(SoVolumeData* volData)
  { m_resultVolData = volData; }

protected:

  /**
   * Called by extraction process to get iteratively the subbox inside boxSize to extract.
   * Default is to return only one complete box (boxSize)
   * @param box to extract in ijk space. It must be contained in boxSize
   * @return FALSE when no more subbox should be extract
   */
  virtual SbBool getNextSubBox(SbBox3i32& box);

  /** Method calls each time a subBox as been computed
  * if FALSE is returned then the whole process is aborted.
  */
  virtual void boxComputed(SoGLRenderAction* action, SoBufferObject* data, const SbBox3i32& box);

SoINTERNAL public:
  static void initClass();
  static void exitClass();

protected:
  /** Destructor */
  virtual ~SoOffscreenVolumeRenderCustom();

  template<typename T> void copyBox(SoBufferObject* data, const SbBox3i32& box);
  SoVolumeData* m_resultVolData;

private:
  void computeDefaultIjkSubBoxes();
  std::vector<SbBox3i32> m_subBoxesIjk;
  size_t m_remainingBox;
};

#endif //_SO_OFFSCREEN_VOLUME_RENDER_CUSTOM_H_


