///////////////////////////////////////////////////////////////////////////////
//
// This program is part of the Open Inventor Medical example set.
//
// Open Inventor customers may use this source code to create or enhance
// Open Inventor-based applications.
//
// The medical utility classes are provided as a prebuilt library named
// "fei.inventor.Medical", that can be used directly in an Open Inventor
// application. The classes in the prebuilt library are documented and
// supported by Thermo Fisher Scientific. These classes are also provided as source code.
//
// Please see $OIVHOME/include/Medical/InventorMedical.h for the full text.
//
///////////////////////////////////////////////////////////////////////////////
/*=======================================================================
** Author      : Pascal Estrade (Jul 2009)
**=======================================================================*/

/*----------------------------------------------------------------------------------------
Medical example program.
Description : Manage events for this demonstration.
----------------------------------------------------------------------------------------*/
#include "manageEvents.h"

static SbBool leftMousePressed = FALSE;


void
	mouseMoveEventCB(void *userData, SoEventCallback *eventCB)
{
	const SoEvent *event = eventCB->getEvent();
	SbVec2s myVec2s = event->getPosition();
	SoDataRange *localDataRange = (SoDataRange*)userData;

	static int horizVal;
	static int vertiVal;

	if( ::leftMousePressed ) {

		double minVal = localDataRange->min.getValue(); 
		if(  myVec2s[0] > horizVal ) {
			minVal += 20;
		} 
		if( myVec2s[0] < horizVal ) {
			minVal -= 20;
		}
		localDataRange->min.setValue(minVal);
		horizVal = myVec2s[0];

		double maxVal = localDataRange->max.getValue(); 
		if(  myVec2s[1] > vertiVal ) {
			maxVal += 10;
		} 
		if( myVec2s[1] < vertiVal ) {
			maxVal -= 10;
		}
		localDataRange->max.setValue(maxVal);
		vertiVal = myVec2s[1];
		//std::cout << "  Min data range: " << minVal << " Max data range: " << maxVal << std::endl;
	}

}
void
	mouseKeyEventCB(void* /*userData*/, SoEventCallback* eventCB)
{
	const SoEvent *event = eventCB->getEvent();

	// Check for mouse button being pressed
	if (SO_MOUSE_PRESS_EVENT(event, BUTTON1)) {
		::leftMousePressed = TRUE;
		eventCB->setHandled();
	} else {
		::leftMousePressed = FALSE;
	}

}

