///////////////////////////////////////////////////////////////////////////////
//
// This program is part of the Open Inventor Medical example set.
//
// Open Inventor customers may use this source code to create or enhance
// Open Inventor-based applications.
//
// The medical utility classes are provided as a prebuilt library named
// "fei.inventor.Medical", that can be used directly in an Open Inventor
// application. The classes in the prebuilt library are documented and
// supported by Thermo Fisher Scientific. These classes are also provided as source code.
//
// Please see $OIVHOME/include/Medical/InventorMedical.h for the full text.
//
///////////////////////////////////////////////////////////////////////////////

#include "SoTransferFunction2D.h"

#include <Inventor/sys/SoGL.h>

#include <Inventor/actions/SoGLRenderAction.h>
#include <Inventor/nodes/SoShaderProgram.h>
#include <Inventor/elements/SoTextureUnitElement.h>
#include <Inventor/SoPreferences.h>

using std::vector;

SO_NODE_SOURCE(SoTransferFunction2D)                              // Static Members

//-----------------------------------------------------------------------------
SoTransferFunction2D::SoTransferFunction2D() {
  SO_NODE_CONSTRUCTOR( SoTransferFunction2D );

  m_tfTexUnit = SoPreferences::getInt("IVVR_TF2D_TEX_UNIT", 15);
}

//-----------------------------------------------------------------------------
SoTransferFunction2D::~SoTransferFunction2D()
{
}

void 
SoTransferFunction2D::initClass()
{
  getClassRenderEngineMode().setRenderMode( SbRenderEngineMode::OIV_OPENINVENTOR_RENDERING );
  SO__NODE_INIT_CLASS(SoTransferFunction2D, "TransferFunction2D", SoTexture2);
}

void
SoTransferFunction2D::exitClass()
{
  SO__NODE_EXIT_CLASS(SoTransferFunction2D);
}

//-----------------------------------------------------------------------------
void
SoTransferFunction2D::GLRender( SoGLRenderAction* action )
{
  SoTextureUnitElement::set(action->getState(), this, m_tfTexUnit) ;

  SoTexture2::GLRender( action );
}


