///////////////////////////////////////////////////////////////////////////////
//
// This program is part of the Open Inventor Medical example set.
//
// Open Inventor customers may use this source code to create or enhance
// Open Inventor-based applications.
//
// The medical utility classes are provided as a prebuilt library named
// "fei.inventor.Medical", that can be used directly in an Open Inventor
// application. The classes in the prebuilt library are documented and
// supported by Thermo Fisher Scientific. These classes are also provided as source code.
//
// Please see $OIVHOME/include/Medical/InventorMedical.h for the full text.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef  _SO_TRANSFER_FUNCTION_2D_
#define  _SO_TRANSFER_FUNCTION_2D_

#include <LDM/SoLDM.h>

#include <Inventor/nodes/SoNode.h>
#include <Inventor/nodes/SoTexture2.h>

class SoGLRenderAction;
class SoCallbackAction;
class SoState;

#ifdef _WIN32
#pragma warning( push )
#pragma warning(disable:4251)
#endif

/**
 * @LDMEXT Describes the association between data set values and colors.
 *
 * @ingroup LDMNodes
 *
 * @DESCRIPTION
 *   This node defines a mapping from a couple of scalar data set values
 *   to color and transparency (alpha) values.
 *
 *
 * @FILE_FORMAT_DEFAULT
 *    TransferFunction2D {
 *    @TABLE_FILE_FORMAT
 *    @TABLE_END
 *    }
 *
 * @ACTION_BEHAVIOR
 * SoCallbackAction,
 * SoGLRenderAction @BR
 * Sets transfer function 2D parameters in the traversal state.
 *
 * @SEE_ALSO
 *    SoVolumeRender,
 *    SoOrthoSlice,
 *    SoObliqueSlice
 */

class SoTransferFunction2D : public SoTexture2 {
  SO_NODE_HEADER( SoTransferFunction2D );

 public:

  /**
   * Constructor
   */
  SoTransferFunction2D();

  //------------------------------------------------------------------------------

 SoEXTENDER public:
  virtual void GLRender( SoGLRenderAction *action );

  //------------------------------------------------------------------------------
 SoINTERNAL public:

  static void initClass();
  static void exitClass();

 protected:
  // Destructor
  virtual ~SoTransferFunction2D();

 private:

   /**
   * Texture unit for the transfer function
   */
  unsigned int m_tfTexUnit;

};

#if defined(_WIN32)
#pragma warning( pop )
#pragma warning(disable:4251)
#endif

#endif // _SO_TRANSFER_FUNCTION_2D_


