///////////////////////////////////////////////////////////////////////////////
//
// This program is part of the Open Inventor Medical example set.
//
// Open Inventor customers may use this source code to create or enhance
// Open Inventor-based applications.
//
// The medical utility classes are provided as a prebuilt library named
// "fei.inventor.Medical", that can be used directly in an Open Inventor
// application. The classes in the prebuilt library are documented and
// supported by Thermo Fisher Scientific. These classes are also provided as source code.
//
// Please see $OIVHOME/include/Medical/InventorMedical.h for the full text.
//
///////////////////////////////////////////////////////////////////////////////

// Multi-transferFunction shader
// Colormap applied to each data voxel is specified by corresponding label voxel.

//!oiv_include <VolumeViz/vvizfnc_frag.h>
//!oiv_include <VolumeViz/vvizGetData_frag.h>
//!oiv_include <VolumeViz/vvizTransferFunction_frag.h>

uniform VVizDataSetId volumeLabel;
uniform VVizDataSetId volumeData;

vec4 VVizComputeFragmentColor(VVizDataSetId dataset, vec3 rayDir, inout VVizVoxelInfo voxelInfoFront, in VVizVoxelInfo voxelInfoBack, int mask)
{
  // Get the label value at this position. Value need to be converted to data range.
  VVIZ_DATATYPE labelValue = VVizGetRawData(volumeLabel, VVizGetNearestCoord(voxelInfoFront)) * 255.;

  // Get the data value.
  VVIZ_DATATYPE sf = VVizGetData(volumeData, voxelInfoFront.texCoord);

  // Apply color map specified by label value.
  return VVizTransferFunction(sf, int(labelValue));
}
