///////////////////////////////////////////////////////////////////////////////
//
// This program is part of the Open Inventor Medical example set.
//
// Open Inventor customers may use this source code to create or enhance
// Open Inventor-based applications.
//
// The medical utility classes are provided as a prebuilt library named
// "fei.inventor.Medical", that can be used directly in an Open Inventor
// application. The classes in the prebuilt library are documented and
// supported by Thermo Fisher Scientific. These classes are also provided as source code.
//
// Please see $OIVHOME/include/Medical/InventorMedical.h for the full text.
//
///////////////////////////////////////////////////////////////////////////////

#pragma once
#include <RemoteViz/Rendering/RenderAreaListener.h>

class RemoteRenderAreaListener : public RemoteViz::Rendering::RenderAreaListener
{
public:
  /** Constructor */
  RemoteRenderAreaListener();

  /** Triggered when a message is received from a client.
   */
  virtual void onReceivedMessage( std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea, 
                                  std::shared_ptr<RemoteViz::Rendering::Connection> sender,
                                  const std::string&                message ) override;

  /** Triggered when the connection and the frame encoders are initialized successfully.
   */
  virtual void onInitializedConnection( std::shared_ptr<RemoteViz::Rendering::RenderArea>    renderArea,  
                                        std::shared_ptr<RemoteViz::Rendering::Connection>    sender,  
                                        std::shared_ptr<const RemoteViz::Rendering::FrameEncoders> frameEncoders ) override;

  /** Triggered when a rendering is done. 
   */
  virtual void onPostRender( std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea ) override;

protected:
  bool m_dataLoaded;
};
