///////////////////////////////////////////////////////////////////////////////
//
// This program is part of the Open Inventor Medical example set.
//
// Open Inventor customers may use this source code to create or enhance
// Open Inventor-based applications.
//
// The medical utility classes are provided as a prebuilt library named
// "fei.inventor.Medical", that can be used directly in an Open Inventor
// application. The classes in the prebuilt library are documented and
// supported by Thermo Fisher Scientific. These classes are also provided as source code.
//
// Please see $OIVHOME/include/Medical/InventorMedical.h for the full text.
//
///////////////////////////////////////////////////////////////////////////////

#pragma once
#include <RemoteViz/Rendering/ServiceListener.h>
#include <RemoteViz/Rendering/RenderAreaListener.h>
#include <RemoteViz/Rendering/NetworkPerformance.h>

class RemoteMPRServiceListener : public RemoteViz::Rendering::ServiceListener
{
public:
  /** Triggered when a client is connected to the service. */
  virtual void onConnectedClient( const std::string& clientId, std::shared_ptr<RemoteViz::Rendering::NetworkPerformance> networkPerformance ) override;

  /*!
  *
  *  Triggered when a renderArea has been instanciated.
  *
  *  \param renderArea : pointer to the instanciated renderArea
  */
  virtual void onInstantiatedRenderArea( std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea ) override;
 };

