///////////////////////////////////////////////////////////////////////////////
//
// This program is part of the Open Inventor Medical example set.
//
// Open Inventor customers may use this source code to create or enhance
// Open Inventor-based applications.
//
// The medical utility classes are provided as a prebuilt library named
// "fei.inventor.Medical", that can be used directly in an Open Inventor
// application. The classes in the prebuilt library are documented and
// supported by Thermo Fisher Scientific. These classes are also provided as source code.
//
// Please see $OIVHOME/include/Medical/InventorMedical.h for the full text.
//
///////////////////////////////////////////////////////////////////////////////

/*----------------------------------------------------------------------------------------
Example program.
Purpose : Demonstrate a simple way to manipulate MPR viewer within remoteViz.
author : Pascal Estrade
December 2015
----------------------------------------------------------------------------------------*/
#include <iostream>
#include <chrono>
#include <thread>
#include "RemoteViz/Rendering/Service.h"
#include "RemoteViz/Rendering/ServiceSettings.h"
#include "medicalRemoteMPRListener.h"

using namespace RemoteViz::Rendering;

///////////////////////////////////////////////////////////////////////////////
int main(int argc, char* argv[])
{
    // Instantiate a service settings class
    auto settings = std::make_shared<ServiceSettings>();
    // set the IP address used by the service
    settings->setIP("127.0.0.1");
    //settings.setIP("auto");
    // set the port used by the service
    settings->setPort(8080);

    //To use an VolumeViz extension with RemoteViz
    settings->setUsedExtensions(ServiceSettings::VOLUMEVIZLDM);
    // Instantiate a serviceListener class to manage the service events.
    auto serviceListener = std::make_shared<medicalRemoteMPRListener>();
    // Instantiate a serviceListener class to manage the service events.
    Service::instance()->addListener(serviceListener);

    // Open the service by using the settings
    if (Service::instance()->open(settings))
    {
        std::cout << "IP : " << settings->getIP() << std::endl;

        std::cout << "Hostname : " << settings->getHostname() << std::endl;
        std::cout <<"The simple medical Rendering Service is running. Press Ctrl + C to stop." << std::endl;
        std::cout <<"\n=> Drag&Drop $OIVHOME/examples/source/Medical/Web/medicalRemoteMPR/Clients/HTML5/index.html\nin your favorite HTML5 browser."<< std::endl;
        while (true)
        {
            Service::instance()->dispatch();
            std::this_thread::sleep_for(std::chrono::milliseconds(1));
        }
        // Close the service
        Service::instance()->close();
    }
    return 0;
}

