////////////////////////////////
//
////////////////////////////////

#include "MeshViewer/MeshViewer.h"
#include <MeshViz/nodes/PoCartesianGrid2D.h>
#include <MeshViz/nodes/PoDomain.h>
#include <Inventor/helpers/SbFileHelper.h>

SbString dataFilePath = SbFileHelper::expandString("$OIVHOME/examples/data/MeshViz/");

int numX,numY;
float *xm,*ym;
float *vm[4];
float vmin[4], vmax[4];

/*----------------------------------------------------------------------------*/
void read_mesh(char *filename, int &nx, float* &x, int &ny, float* &y, SbVec3f &min, SbVec3f &max) 
{

  float x_min, y_min, x_max, y_max, xx,yy ;
  int i,num_x,num_y;

  FILE *file_rep;
  SbString SbFileName= dataFilePath;
  SbFileName += filename;

  file_rep = SbFileHelper::open (SbFileName , "r" );
  if (file_rep == NULL ) {
    printf ("file %s not found\n",SbFileName.toLatin1());
    exit(1);
  }

  fscanf (file_rep , "%d %d" , &num_x, &num_y);
  float *xt = new float [num_x * num_y];
  float *yt = new float [num_x * num_y];

  fscanf(file_rep,"%f %f",&xx,&yy);
  xt[0] = x_min = x_max = xx;
  yt[0] = y_min = y_max = yy;
  for (i=1; i<num_x*num_y; i++) {
    fscanf(file_rep,"%f %f",&xx,&yy);
    if (x_min > xx) x_min = xx;
    if (y_min > yy) y_min = yy;
    if (x_max < xx) x_max = xx;
    if (y_max < yy) y_max = yy;
    xt[i] = xx;
    yt[i] = yy;
  }

  fclose(file_rep);

  nx = num_x;
  ny = num_y;
  x = xt;
  y = yt;
  min.setValue(x_min, y_min, 0);
  max.setValue(x_max, y_max, 64);

}/*---------------------------------------------------------------------------*/


void read_val(char *filename, int num_val, float* &v)
{
  FILE *file_rep;
  SbString SbFileName= dataFilePath;
  SbFileName += filename;

  file_rep = SbFileHelper::open ( SbFileName , "r" );
  if (file_rep == NULL ) {
    printf ("file %s not found\n",SbFileName.toLatin1());
    exit(2);
  }

  v = new float [num_val];
  for (int i=0; i<num_val; i++) fscanf(file_rep,"%f",&v[i]);
}/*---------------------------------------------------------------------------*/


int main(int, char **)
{
  SbVec3f min,max;
  read_mesh((char*)"CARTGRID.TOPO", numX, xm, numY, ym, min,max);
  read_val((char*)"GRID0.DAT", numX*numY, vm[0]);
  read_val((char*)"GRID1.DAT", numX*numY, vm[1]);
  read_val((char*)"GRID2.DAT", numX*numY, vm[2]);
  read_val((char*)"GRID3.DAT", numX*numY, vm[3]);

  // Initialize 3D-Master-Suite classes
  PoMeshViz::init() ;
  
  PoCartesianGrid2D *mesh = new PoCartesianGrid2D;
  mesh->setGeometry (numX, numY, xm,ym);
  for (int i=0; i<4; i++) mesh->addValuesSet(i,vm[i]);

  PoDomain *domain = new PoDomain;
  domain->min = min;
  domain->max = max;
  
  MeshViewer *mesh_viewer = new MeshViewer();
  mesh_viewer->setWindowTitle("CartesianGrid2D");
  mesh_viewer->setDataSetIndex(3);
  mesh_viewer->show(mesh,domain);

  delete mesh_viewer;

  PoMeshViz::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


