////////////////////////////////
//
////////////////////////////////

#define PI 3.1415927F
#define RADIUS_MIN 1.0F
#define RADIUS_MAX 4.0F
#define NUM_ROUND  0.5F

#include "MeshViewer.h"
#include <MeshViz/nodes/PoCartesianGrid3D.h>
#include <Inventor/SoPreferences.h>



static const int num_data_set = 10;
static const int num_x=40,num_y=40,num_z=40;
float x[num_x][num_y][num_z], y[num_x][num_y][num_z], z[num_x][num_y][num_z];
float v[num_data_set][num_x][num_y][num_z];

/*---------------------------------------------------------------------- */
void build_mesh () {
  float  *r,*t,*zt,
         tmin,tmax,helice_ht,
         xmin,ymin,zmin, xmax,ymax,zmax,
         delta_r,delta_t,delta_zj,delta_zk;
  int   i ,j ,k ;
  
  tmin = 0.0F; tmax = NUM_ROUND * 2.0F * PI;
  zmin = 0.0F; zmax = zmin + RADIUS_MAX*2.0F;

  helice_ht = (zmax-zmin)/(NUM_ROUND*2.5F);
  delta_zk  = helice_ht/(num_z-1);
  delta_zj  = (zmax-helice_ht-zmin)/(num_y-1);
  
  r = new float [num_x];
  t = new float [num_y];
  zt = new float [num_y];

  delta_r = (RADIUS_MAX-RADIUS_MIN)/(num_x-1);
  delta_t = (tmax-tmin)/(num_y-1);

  for ( i=0 ; i<num_x; i++ ) r[i] = RADIUS_MIN + i*delta_r;
  for ( j=0 ; j<num_y; j++ ) t[j] = tmin + j*delta_t;
  for ( j=0 ; j<num_y; j++ ) zt[j] = zmin + j*delta_zj;

  xmin = ymin = zmin =  1.0E30F;
  xmax = ymax = zmax = -1.0E30F;

  for ( i=0 ; i<num_x; i++ ) 
    for ( j=0 ; j<num_y; j++ ) 
      for ( k=0 ; k<num_z; k++ ) {
        x[i][j][k] = r[i] * cos(t[j]);
        if (xmax<x[i][j][k]) xmax = x[i][j][k];
        if (xmin>x[i][j][k]) xmin = x[i][j][k];
      }
  
  for ( i=0 ; i<num_x; i++ ) 
    for ( j=0 ; j<num_y; j++ ) 
      for ( k=0 ; k<num_z; k++ ) {
        y[i][j][k] = r[i] * sin(t[j]);
        if (ymax<y[i][j][k]) ymax = y[i][j][k];
        if (ymin>y[i][j][k]) ymin = y[i][j][k];
      }
  
  for ( i=0 ; i<num_x; i++ ) 
    for ( j=0 ; j<num_y; j++ ) {
      z[i][j][0] = zt[j];
      if (zmax<z[i][j][0]) zmax = z[i][j][0];
      if (zmin>z[i][j][0]) zmin = z[i][j][0];
      for ( k=1 ; k<num_z; k++ ) {
        z[i][j][k] = z[i][j][k-1] + delta_zk;
        if (zmax<z[i][j][k]) zmax = z[i][j][k];
        if (zmin>z[i][j][k]) zmin = z[i][j][k];
      }
    }

  delete [] r;
  delete [] t;
  delete [] zt;
  
}
/*---------------------------------------------------------------------- */

void compute_data () {
  float         *xt,*yt,*zt, xc,yc,zc, 
                xmin,ymin,zmin, xmax,ymax,zmax;
  int           nx,ny,nz, i,j,k;

  nx = num_x;
  ny = num_y;
  nz = num_z;
  xt = new float [nx];
  yt = new float [ny];
  zt = new float [nz];

  xmin = ymin = zmin = -2.0;
  xmax = ymax = zmax =  2.0;
  for ( i=0 ; i<nx; i++ ) xt[i] = xmin + i*(xmax-xmin)/(nx-1);
  for ( j=0 ; j<ny; j++ ) yt[j] = ymin + j*(ymax-ymin)/(ny-1);
  for ( k=0 ; k<nz; k++ ) zt[k] = zmin + k*(zmax-zmin)/(nz-1);

  for ( i=0; i<nx; i++ ) for ( j=0; j<ny; j++ ) for ( k=0; k<nz; k++ ) 
    v[0][i][j][k] = x[i][0][0];

  for ( i=0; i<nx; i++ ) for ( j=0; j<ny; j++ ) for ( k=0; k<nz; k++ ) 
    v[1][i][j][k] = y[0][j][0];

  for ( i=0; i<nx; i++ ) for ( j=0; j<ny; j++ ) for ( k=0; k<nz; k++ ) 
    v[2][i][j][k] = z[0][0][k];

  for ( i=0 ;i < nx ;i++ ) {
    xc = xt[i]*xt[i];
    for (j=0 ;j < ny ;j++ ) {
      yc = yt[j]*yt[j];
      for ( k=0 ;k < nz ;k++ ) {
	zc = zt[k]*zt[k];
	v[3][i][j][k] = xc + yc + zc;
      }
    }
  }

  for ( i=0 ;i < nx ;i++ ) {
    xc = xt[i]*xt[i];
    for (j=0 ;j < ny ;j++ ) {
      yc = yt[j];
      for ( k=0 ;k < nz ;k++ ) {
	zc = zt[k]*zt[k]*zt[k];
	v[4][i][j][k] = xc + yc + zc;
      }
    }
  }

  for ( i=0 ;i < nx ;i++ ) {
    xc = xt[i]*xt[i];
    for (j=0 ;j < ny ;j++ ) {
      yc = 5*yt[j];
      for ( k=0 ;k < nz ;k++ ) {
	zc = zt[k]*zt[k];
	v[5][i][j][k] = xc + yc + zc;
      }
    }
  }

  for ( i=0 ;i < nx ;i++ ) {
    xc = xt[i]*xt[i];
    for (j=0 ;j < ny ;j++ ) {
      yc = yt[j]*yt[j]*yt[j];
      for ( k=0 ;k < nz ;k++ ) {
	zc = zt[k]*zt[k];
	v[6][i][j][k] = xc + yc + zc*zc;
      }
    }
  }

  for ( i=0 ;i < nx ;i++ ) {
    xc = xt[i]*xt[i];
    for (j=0 ;j < ny ;j++ ) {
      yc = yt[j];
      for ( k=0 ;k < nz ;k++ ) {
	zc = zt[k];
	v[7][i][j][k] = xc*yc + zc;
      }
    }
  }

  for ( i=0 ;i < nx ;i++ ) {
    xc = xt[i]*xt[i];
    for (j=0 ;j < ny ;j++ ) {
      yc = yt[j]*yt[j];
      for ( k=0 ;k < nz ;k++ ) {
	zc = zt[k];
	v[8][i][j][k] = xc*yc + zc*xt[i];
      }
    }
  }

  for ( i=0 ;i < nx ;i++ ) {
    xc = xt[i];
    for (j=0 ;j < ny ;j++ ) {
      yc = yt[j];
      for ( k=0 ;k < nz ;k++ ) {
	zc = zt[k];
	v[9][i][j][k] = xc*yc*zc;
      }
    }
  }

  delete [] xt;
  delete [] yt;
  delete [] zt;
}

/*---------------------------------------------------------------------------*/

int main(int, char **)
 {
  static const char *data_names[num_data_set] = {
    "X",
    "Y",
    "Z",
    "X*X + Y*Y + Z*Z",
    "X*X + Y + Z*Z*Z",
    "X*X + 5Y + Z*Z",
    "X*X + Y*Y*Y + Z*Z*Z*Z",
    "X*X*Y + Z",
    "X*X*Y*Y + Z*X",
    "X*Y*Z"
  };

  build_mesh();
  compute_data();

  // Initialize MeshViz classes
  PoMeshViz::init() ;

  // Build a 3D grid mesh without duplicating the data set in memory
  PbCartesianGrid3D pb_mesh(num_x,num_y,num_z, x[0][0],y[0][0],z[0][0],FALSE);
  for (int i=0; i<num_data_set; i++) 
    pb_mesh.addValuesSet(i,v[i][0][0],data_names[i]);
 
  PoCartesianGrid3D *mesh = new PoCartesianGrid3D;
  mesh->mesh.setValue(pb_mesh);

  MeshViewer *mesh_viewer = new MeshViewer();
  mesh_viewer->setWindowTitle("PbCartesianGrid3D");
  mesh_viewer->show(mesh);

  delete mesh_viewer;

  PoMeshViz::finish();
  return 0;
}/*---------------------------------------------------------------------------*/


  


