////////////////////////////////
//
////////////////////////////////

#include "../TgsDemo.h"
#include "MeshViewer.h"
#include <MeshViz/nodes/PoHexahedronMesh3D.h>
#include <Inventor/SoPreferences.h>
#include <Inventor/helpers/SbFileHelper.h>

SbString dataFilePath = SbFileHelper::expandString("$OIVHOME/examples/data/MeshViz/");

/*---------------------------------------------------------------------- */
void read_file (char *file_name, int &num_nodes, float *&xm, float *&ym, float *&zm, float **vm, 
		int &num_hexahedrons, int *&hexahedron_node) {
  FILE   *mesh_file;
  int   i;
  SbString SbFileName= dataFilePath;
  SbFileName += file_name;
  
  printf ("reading file %s\n",file_name);
  mesh_file = SbFileHelper::open ( SbFileName , "r" );
  
  fscanf (mesh_file,"%d %d",&num_hexahedrons,&num_nodes);
  printf ("with %d hexahedrons and %d nodes\n",num_hexahedrons,num_nodes);

  hexahedron_node = new int [num_hexahedrons*8];
  for (i=0; i<num_hexahedrons*8; i++) 
    fscanf (mesh_file,"%d",&hexahedron_node[i]);

  xm = new float [num_nodes];
  ym = new float [num_nodes];
  zm = new float [num_nodes];
  for (i=0; i<num_nodes; i++) 
    fscanf (mesh_file,"%f %f %f",&xm[i],&ym[i],&zm[i]);

  vm[0] = new float [num_nodes];
  vm[1] = new float [num_nodes];
  vm[2] = new float [num_nodes];
  vm[3] = new float [num_nodes];
  vm[4] = new float [num_nodes];
  for (i=0; i<num_nodes; i++) 
    fscanf (mesh_file,"%f %f %f %f %f",&vm[0][i],&vm[1][i],&vm[2][i],&vm[3][i],&vm[4][i]);
    
  fclose (mesh_file);
  printf ("end reading file\n");

}/*---------------------------------------------------------------------- */

int main(int, char **)
{
  FILE *f;
  SbString SbFileName= dataFilePath;
  SbFileName += "poi3u32.txt";
  f = SbFileHelper::open ( SbFileName , "r" );
  if (f == NULL) {
    ShowMessage((char*)"Data file not found or not installed. \nYou may need to download the optional MeshViz data files. \n",
                (char*)"Machining");
    exit(1);
  }
  fclose(f);
	
  int i;
  const int num_data_set = 5;
  int num_nodes,num_hexahedrons, *hexahedron_nodes;
  float *xm,*ym,*zm, *vm[num_data_set];

  static const char *data_names[num_data_set] = {
    "density",
    "momentum U",
    "momentum V",
    "momentum W",
    "enthalpy"
  };
  read_file ((char*)"TURBO.DAT", num_nodes, xm,ym,zm,vm, num_hexahedrons, hexahedron_nodes);

  // Initialize MeshViz classes
  PoMeshViz::init();

  // Build a 3D mesh without duplicating the data set in memory
  PbHexahedronMesh3D pb_mesh(num_nodes,xm,ym,zm, num_hexahedrons, hexahedron_nodes,FALSE);
  for (i=0; i<num_data_set; i++)
    pb_mesh.addValuesSet(i,vm[i],data_names[i]);

  SbVec3f *vec = new SbVec3f [num_nodes];
  for (i=0; i<num_nodes; i++) vec[i].setValue(vm[1][i],vm[2][i],vm[3][i]);
  pb_mesh.addVecsSet(0,vec);

  PoHexahedronMesh3D *mesh = new PoHexahedronMesh3D;
  mesh->mesh.setValue(pb_mesh);

  MeshViewer *mesh_viewer = new MeshViewer();
  mesh_viewer->setWindowTitle("PbHexahedronMesh3D");
  mesh_viewer->setCourtesyTitle("by courtesy of Turbomeca");
  mesh_viewer->show(mesh);

  delete mesh_viewer;

  PoMeshViz::finish();
  return 0;
}/*---------------------------------------------------------------------------*/


