#if defined(_WIN32)
#pragma warning(disable: 4996) // Disable PoXt deprecation warning
#endif

#include "Vec3DViewer.h"
#include <MeshViz/nodes/PoHexahedronMesh3D.h>


#include <Inventor/SoWinApp.h>

int  main(int, char **)
{
  static const int num_nodes=16, num_elems=3;
  static float x[num_nodes] = { 0,1,2, 0,1,2, 1,2.5, 0,1,2, 0,1,2, 1,2.5 };
  static float y[num_nodes] = { 0,0,-1, 1,1,1, 2,2.5, 0,0,-1, 1,1,1, 2,2.5};  
  static float z[num_nodes] = { 0,0,0,0,0,0,0,0, 1,1,1,1,1,1,1,1};
  static int elem_index[] = {0,1,4,3,8,9,12,11, 1,2,5,4,9,10,13,12, 4,5,7,6,12,13,15,14};

  static float val[num_nodes] = {0,1,1,2,5,2,3,1, 1,1,2,2,5,4,3,1};
  SbVec3f vec[num_nodes];
  vec[0].setValue(0.1F,0.2F,0.3F);
  vec[1].setValue(0.3F,-0.1F,0.2F);
  vec[2].setValue(0.F, 0.2F, -0.5F);
  vec[3].setValue(-0.3F, 0.1F, 0.2F);
  vec[4].setValue(-0.3F, -0.1F, 0.3F);
  vec[5].setValue(0.1F,0.2F,0.3F);
  vec[6].setValue(0.3F,-0.1F,0.2F);
  vec[7].setValue(0.F, 0.2F, -0.5F);
  vec[8].setValue(-0.3F, 0.1F, 0.2F);
  vec[9].setValue(-0.3F, -0.1F, 0.6F);
  vec[10].setValue(0.3F, 0.1F, 0.3F);
  vec[11].setValue(-0.3F, -0.1F, 1.3F);
  vec[12].setValue(0.3F, -0.1F, 0.3F);
  vec[13].setValue(-0.3F, -1.1F, 0.3F);
  vec[14].setValue(0.3F, 0.1F, 0.3F);
  vec[15].setValue(-0.3F, -0.1F, -.3F);
  
  // initialize Master-Suite classes
  PoMeshViz::init() ;

  PoHexahedronMesh3D *mesh = new PoHexahedronMesh3D;
  mesh->setGeometry(num_nodes,x,y,z, num_elems, elem_index);
  mesh->addValuesSet(0,val);
  mesh->addVecsSet(0,vec);

  Vec3DViewer* vec_viewer = new Vec3DViewer;
  vec_viewer->setTitle("PoHexahedronMesh3D");
  vec_viewer->show(mesh);
  delete vec_viewer;

  PoMeshViz::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


