#if defined(_WIN32)
#pragma warning(disable: 4996) // Disable PoXt deprecation warning
#endif

#include "Vec2DViewer.h"
#include <MeshViz/nodes/PoIndexedMesh2D.h>


#include <Inventor/SoWinApp.h>

int  main(int, char **)
{
  static const int num_nodes=6, num_elems=3;
  static float x[num_nodes] = {  0,1,-1, 5,6,4 };
  static float y[num_nodes] = {  1,-0.5,-1, 1,0,0 };
  static int elem_index[] = {0,1,2, 1,0,3,5, 3,4,5};
  static int elem_type[num_elems] = {3,4,3};

  static float val[num_nodes] = {0,1,1,2,4,5};
  static float alt[num_nodes] = {0,0,1,0,0,0};
  SbVec3f vec[num_nodes];

  // initialize Master-Suite classes
  PoMeshViz::init() ;

  vec[0].setValue(0.1F,0.2F,0.0F);
  vec[1].setValue(0.3F,-0.1F,0.0F);
  vec[2].setValue(0.F, 0.2F,0.0F);
  vec[3].setValue(-0.3F, 0.1F,0.0F);
  vec[4].setValue(-0.3F, -0.1F,0.0F);
  vec[5].setValue(-0.3F, 0.1F,0.0F);
  
  PoIndexedMesh2D *mesh = new PoIndexedMesh2D;
  mesh->setGeometry(num_nodes,x,y, num_elems, elem_index, elem_type);
  mesh->addValuesSet(0,val);
  mesh->addValuesSet(1,alt);
  mesh->addVecsSet(0,vec);

  Vec2DViewer* vec_viewer = new Vec2DViewer;
  vec_viewer->setTitle("PoIndexedMesh2D");
  vec_viewer->show(mesh);
  delete vec_viewer;

  PoMeshViz::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


