#if defined(_WIN32)
#pragma warning(disable: 4996) // Disable PoXt deprecation warning
#endif

#include "Vec3DViewer.h"
#include <MeshViz/nodes/PoIndexedMesh3D.h>


#include <Inventor/SoWinApp.h>

int  main(int, char **)
{
  static const int num_nodes=8, num_elems=3;
  static float x[num_nodes] = {  0,1,-1,0, 5,6,4,5 };
  static float y[num_nodes] = {  0,0,0,2, 0,0,0,2 };
  static float z[num_nodes] = {  1,-1,0,0, 1,0,-1,0 };
  static int elem_index[] = {0,2,1,3, 4,6,5,7, 0,3,1,4,7,6};
  static int elem_type[num_elems] = {4,4,6};

  static float val[num_nodes] = {0,1,1,2,4,5,3,0};
  SbVec3f vec[num_nodes];
  vec[0].setValue(0.1F,0.2F,0.3F);
  vec[1].setValue(0.3F,-0.1F,0.2F);
  vec[2].setValue(0.F, 0.2F, -0.5F);
  vec[3].setValue(-0.3F, 0.1F, 0.2F);
  vec[4].setValue(-0.3F, -0.1F, 0.3F);
  vec[5].setValue(-0.3F, 0.1F, -0.3F);
  vec[6].setValue(0.6F, 0.1F, 0.2F);
  vec[7].setValue(-0.5F, 0.5F, -0.9F);
  
  // initialize Master-Suite classes
  PoMeshViz::init() ;

  PoIndexedMesh3D *mesh = new PoIndexedMesh3D;
  mesh->setGeometry(num_nodes,x,y,z, num_elems, elem_index, elem_type);
  mesh->addValuesSet(0,val);
  mesh->addVecsSet(0,vec);

  Vec3DViewer* vec_viewer = new Vec3DViewer;
  vec_viewer->setTitle("PoIndexedMesh3D");
  vec_viewer->show(mesh);
  delete vec_viewer;

  PoMeshViz::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


