////////////////////////////////
// mesh cross section
////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <MeshViz/nodes/PoNonLinearDataMapping2.h>
#include <MeshViz/nodes/PoTetrahedronMesh3D.h>
#include <MeshViz/3Ddata/PoMeshSkeleton.h>
#include <MeshViz/3Ddata/PoMeshCrossSection.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/helpers/SbFileHelper.h>

SbString dataFilePath = SbFileHelper::expandString("$OIVHOME/examples/data/MeshViz/");

/*---------------------------------------------------------------------- */

void read_mesh (const char *file_name, int &num_nodes, float *&x, float *&y, float *&z, float **vm, SbVec3f *&vec, 
		int &num_tetrahedrons, int *&tetrahedron_node)
{
  int   i;
  SbString SbFileName= dataFilePath;
  SbFileName += file_name;
  FILE *fp;

  fp = SbFileHelper::open ( SbFileName , "r" );
  if (fp == NULL ) {
    printf ("file %s not found\n", SbFileName.toLatin1());
    exit(0);
  }

  fscanf (fp, "%d%d", &num_nodes, &num_tetrahedrons);

  printf ("   num nodes       %d\n",num_nodes);
  printf ("   num tetahedrons %d\n",num_tetrahedrons);

  printf ("reading nodes coordinates\n");
  x = (float *)malloc(num_nodes*sizeof(float));
  y = (float *)malloc(num_nodes*sizeof(float));
  z = (float *)malloc(num_nodes*sizeof(float));
  for (i=0; i<num_nodes; i++) fscanf(fp, "%e%e%e", &x[i], &y[i], &z[i]);

  printf ("reading nodes vectors\n");
  vec = new SbVec3f [num_nodes];
  float vx,vy,vz;
  for (i=0; i<num_nodes; i++) {
    fscanf(fp, "%e%e%e", &vx, &vy, &vz);
    vec[i].setValue(vx,vy,vz);
  }

  printf ("reading value\n");
  vm[0] = (float *)malloc(num_nodes*sizeof(float));
  for (i=0; i<num_nodes; i++) fscanf (fp , "%f " , &vm[0][i]);

  vm[1] = (float *)malloc(num_nodes*sizeof(float));
  for (i=0; i<num_nodes; i++) fscanf (fp , "%f " , &vm[1][i]);

  vm[2] = (float *)malloc(num_nodes*sizeof(float));
  for (i=0; i<num_nodes; i++) fscanf (fp , "%f " , &vm[2][i]);

  vm[3] = (float *)malloc(num_nodes*sizeof(float));
  for (i=0; i<num_nodes; i++) fscanf (fp , "%f " , &vm[3][i]);

  int c;
  for (i=0; i<num_nodes; i++) fscanf(fp, "%d", &c);

  printf ("reading tetahedrons nodes indices\n");
  int *tn = tetrahedron_node = (int *)malloc(num_tetrahedrons*4*sizeof(int));
  for (i=0; i<num_tetrahedrons; i++) {
    int n0,n1,n2,n3;
    fscanf (fp , "%d%d%d%d" , &n0,&n1,&n2,&n3);
    *tn++ = n0;
    *tn++ = n2;
    *tn++ = n1;
    *tn++ = n3;
  }

  printf ("end reading file \n\n");

}/*---------------------------------------------------------------------------*/
#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
  // initialize inventor classes
  Widget my_window = SoXt::init(argv[0]);
  if (my_window == NULL) exit(1) ;

  // initialize Master-Suite classes
  PoMeshViz::init() ;
  
  int num_nodes,num_tetrahedrons, *tetrahedron_node;
  float *xm,*ym,*zm, *vm[4];
  SbVec3f *vec;
  read_mesh("MESH_TETR.DAT", num_nodes, xm,ym,zm,vm, vec, num_tetrahedrons, tetrahedron_node);

  // build the mesh object
  PoTetrahedronMesh3D *mesh = new PoTetrahedronMesh3D;
  mesh->setGeometry(num_nodes,xm,ym,zm, num_tetrahedrons, tetrahedron_node);

  // add a set of scalar values to this mesh
  mesh->addValuesSet(0,vm[0]);

  const PbMesh *pb_mesh = mesh->getMesh();

  // get the min-max value of this set
  float vmin,vmax;
  pb_mesh->getMinValuesSet(0,vmin);
  pb_mesh->getMaxValuesSet(0,vmax);
  
  // define a data-mapping associated to this data-set
  SbColor colors[5] = {SbColor(0.0,0.0,1.0), SbColor(0.0,1.0,1.0), SbColor(0.0,1.,0.), 
		       SbColor(1.0,1.0,0.0), SbColor(1.0,0.0,0.0)} ;
  float val[5];
  val[0] = vmin; for (int j=1; j<5; j++) val[j] = val[j-1] + (vmax-vmin)/4;
  PoNonLinearDataMapping2 *dataMapping = new PoNonLinearDataMapping2;
  dataMapping->value.setValues(0,5,val);
  dataMapping->color.setValues(0,5,colors);
  dataMapping->type = PoNonLinearDataMapping2::LINEAR_PER_LEVEL;

  // define the mesh skeleton
  PoMeshSkeleton *v_MeshSkeleton = new PoMeshSkeleton;

  // define the cross section
  PoMeshCrossSection *v_MeshCrossSection = new PoMeshCrossSection;
  v_MeshCrossSection->plane.setValue(SbPlane(SbVec3f(1,0,0),pb_mesh->getBoundingBox().getCenter()));
  v_MeshCrossSection->valuesIndex.setValue(0);
  v_MeshCrossSection->coloringType = PoMesh::COLOR_MAPPING;

  // build the scene-graph root
  SoGroup *root = new SoGroup;
  root->ref();
  root->addChild(mesh);
  root->addChild(dataMapping);
  root->addChild(v_MeshSkeleton);
  root->addChild(v_MeshCrossSection);

  SoXtExaminerViewer *v_Viewer = new SoXtExaminerViewer(my_window);
  v_Viewer->setSceneGraph(root);
  v_Viewer->setTitle("cross section");
  v_Viewer->show();
  v_Viewer->viewAll();

  SoXt::show(my_window);
  SoXt::mainLoop();

  delete v_Viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


