////////////////////////////////
// mesh isosurface
////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <MeshViz/nodes/PoNonLinearDataMapping2.h>
#include <MeshViz/nodes/PoCartesianGrid3D.h>
#include <MeshViz/3Ddata/PoMeshLevelSurf.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/helpers/SbFileHelper.h>

SbString dataFilePath = SbFileHelper::expandString("$OIVHOME/examples/data/MeshViz/");

static const int num_x=32,num_y=32,num_z=30;
float x[num_x][num_y][num_z], y[num_x][num_y][num_z], z[num_x][num_y][num_z];
float local_v[num_x][num_y][num_z];

#define PMIN(a,b) ((a)<(b)?(a):(b))
#define PMAX(a,b) ((a)>(b)?(a):(b))
/*---------------------------------------------------------------------- */


void read_topologie (const char *filnam, float &xmin, float &ymin, float &zmin, 
                     float &xmax, float &ymax, float &zmax ) {
  FILE *stream ;
  SbString SbFileName= dataFilePath;
  SbFileName += filnam;
  float xc ,yc ,dc ;
  int i ,j ,k ;
  
  dc = 625;

  xc = 0.0;
  for ( i=0; i<num_x; i++ ) {
    for ( j=0; j<num_y; j++ ) {
      for ( k=0; k<num_z; k++ ) {
        x[i][j][k] = xc;
      }
    }
    xc += dc;
  }
  xmin = 0. ;
  xmax = x[num_x-1][0][0] ;
  
  yc = 0.0;
  for ( j=0; j<num_y; j++ ) {
    for ( i=0; i<num_x; i++ ) {
      for ( k=0; k<num_z; k++ ) {
        y[i][j][k] = yc;
      }
    }
    yc += dc;
  }
  ymin = 0. ;
  ymax = y[0][num_y-1][0] ;
  
  printf ("start reading geometry file %s : %d %d %d\n", filnam, num_x, num_y, num_z);
  stream = SbFileHelper::open (SbFileName, "r" );
  if ( stream == NULL ) { printf("file %s not found\n",SbFileName.toLatin1()); exit(1) ;}

  zmin =  1.E30F ;
  zmax = -1.E30F ;
  for ( k=0; k<num_z; k++ ) {
    for ( j=0; j<num_y; j++ ) {
      for ( i=0; i<num_x; i++ ) {
        fscanf(stream,"%f", &z[i][j][k] ) ;
        zmin = PMIN( zmin , z[i][j][k] ) ;
        zmax = PMAX( zmax , z[i][j][k] ) ;
      }
    }
  }

  fclose ( stream ) ;
  
}

/***************************************************************************/
void read_value (const char *filnam) {
  FILE *stream ;
  SbString SbFileName= dataFilePath;
  SbFileName += filnam;
  int i ,j ,k ;
  
  printf("Start reading file %s... \n", filnam);
  stream = SbFileHelper::open ( SbFileName , "r" );
  if ( stream == NULL ) { printf("file %s not found \n",SbFileName.toLatin1()); exit(1);}
  
  for ( k=0; k<num_z; k++ ) {
    for ( j=0; j<num_y; j++ ) {
      for ( i=0; i<num_x; i++ ) {
        fscanf( stream , "%f" , &local_v[i][j][k] ) ;
      }
    }
  } 

  fclose ( stream ) ;  

}

/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
  // initialize inventor classes
  Widget my_window = SoXt::init(argv[0]);
  if (my_window == NULL) exit(1) ;

  // initialize Master-Suite classes
  PoMeshViz::init() ;

  // In order to keep the compatibility with MeshViz 5.0
  SoPreferences::setFloat("OIV_3DDATA_CREASE_ANGLE",0.8f);
  
  // read the topology and the value of the mesh
  float xmin,ymin,zmin, xmax,ymax,zmax;
  read_topologie("poi3z32.txt",xmin,ymin,zmin, xmax,ymax,zmax);
  read_value("poi3v32.txt");

  // build the mesh object
  PoCartesianGrid3D *mesh = new PoCartesianGrid3D;
  mesh->setGeometry(num_x,num_y,num_z,x[0][0],y[0][0],z[0][0]);

  // add a set of scalar values to this mesh
  mesh->addValuesSet(0,local_v[0][0]);

  const PbMesh *pb_mesh = mesh->getMesh();

  // get the min-max value of this set
  float vmin,vmax;
  pb_mesh->getMinValuesSet(0,vmin);
  pb_mesh->getMaxValuesSet(0,vmax);
  
  // define a data-mapping associated to this data-set
  SbColor colors[5] = {SbColor(0.0,0.0,1.0), SbColor(0.0,1.0,1.0), SbColor(0.0,1.,0.), 
		       SbColor(1.0,1.0,0.0), SbColor(1.0,0.0,0.0)} ;
  float val[5];
  val[0] = vmin; for (int j=1; j<5; j++) val[j] = val[j-1]+ (vmax-vmin)/4;
  PoNonLinearDataMapping2 *dataMapping = new PoNonLinearDataMapping2;
  dataMapping->value.setValues(0,5,val);
  dataMapping->color.setValues(0,5,colors);
  dataMapping->type = PoNonLinearDataMapping2::LINEAR_PER_LEVEL;

  // define the scene-graph root
  SoGroup *root = new SoGroup;
  root->ref();
  root->addChild(mesh);
  root->addChild(dataMapping);
  
  int num_level = 4;
  float delta_level = (vmax-vmin)/num_level, level = vmin+delta_level/2;

  // define the level surface
  for (int i=0; i<num_level; i++, level+=delta_level) {
    PoMeshLevelSurf *v_MeshLevelSurf = new PoMeshLevelSurf;
    v_MeshLevelSurf->valuesIndex.setValue(0);
    v_MeshLevelSurf->coloringType = PoMesh::COLOR_MAPPING;
    v_MeshLevelSurf->levelValue = level;
    root->addChild(v_MeshLevelSurf);
  }

  SoXtExaminerViewer *v_Viewer = new SoXtExaminerViewer(my_window);
  v_Viewer->setSceneGraph(root);
  v_Viewer->setTitle("level surfaces");
  v_Viewer->show();
  v_Viewer->viewAll();

  SoXt::show(my_window);
  SoXt::mainLoop();

  delete v_Viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


