////////////////////////////////
// mesh limit
////////////////////////////////

#include <string.h>
#include <stdio.h>

#include <MeshViz/nodes/PoTriangleMesh2D.h>
#include <MeshViz/3Ddata/PoMeshLimit.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/helpers/SbFileHelper.h>

SbString dataFilePath = SbFileHelper::expandString("$OIVHOME/examples/data/MeshViz/");

/*---------------------------------------------------------------------- */

void read_mesh (const char *file_name, int &num_nodes, float *&x, float *&y, int &num_triangles, int *&triangle_node)
{
  int   i;
  SbString SbFileName= dataFilePath;
  SbFileName += file_name;
  FILE *fp;

  fp = SbFileHelper::open ( SbFileName, "r" );
  if (fp == NULL ) {
    printf ("file %s not found\n",SbFileName.toLatin1());
    exit(0);
  }

  fscanf (fp , "%d%d" , &num_triangles, &num_nodes);

  printf ("reading file %s %d triangles, %d vertices \n",file_name,num_triangles,num_nodes);

  int *tn = triangle_node = (int *)malloc(num_triangles*3*sizeof(int));
  for (i=0; i<num_triangles; i++) {
    int n0,n1,n2;
    fscanf (fp , "%d%d%d" , &n0,&n1,&n2);
    *tn++ = n0;
    *tn++ = n1;
    *tn++ = n2;
  }

  x = (float *)malloc(num_nodes*sizeof(float));
  y = (float *)malloc(num_nodes*sizeof(float));

  for (i=0; i<num_nodes; i++)fscanf (fp , "%f %f" , &x[i], &y[i]);
  printf ("end reading file \n\n");

}


/*---------------------------------------------------------------------- */

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
  // initialize inventor classes
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;

  // initialize Master-Suite classes
  PoMeshViz::init() ;

  int num_nodes,num_triangles, *triangle_node;
  float *xm,*ym;
  read_mesh("TRIANGLE.TOPO", num_nodes, xm,ym, num_triangles, triangle_node);

  // build the mesh object
  PoTriangleMesh2D *mesh = new PoTriangleMesh2D;
  mesh->setGeometry(num_nodes,xm,ym, num_triangles, triangle_node);

  // define the mesh limit
  PoMeshLimit *meshLimit = new PoMeshLimit;
   
  // build the scene-graph root
  SoGroup *root = new SoGroup;
  root->addChild(mesh);
  root->addChild(meshLimit);

  SoXtExaminerViewer *viewer = new SoXtExaminerViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setTitle("mesh limit");
  viewer->show();
  viewer->viewAll();

  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete viewer;

  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


