////////////////////////////////
// mesh lines
////////////////////////////////

#include <string.h>
#include <stdio.h>

#include <MeshViz/nodes/PoNonLinearDataMapping2.h>
#include <MeshViz/nodes/PoTriangleMesh2D.h>
#include <MeshViz/3Ddata/PoMeshLines.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/helpers/SbFileHelper.h>

SbString dataFilePath = SbFileHelper::expandString("$OIVHOME/examples/data/MeshViz/");
/*---------------------------------------------------------------------- */

void read_mesh (const char *file_name, int &num_nodes, float *&x, float *&y, int &num_triangles, int *&triangle_node)
{
  int   i;
  SbString SbFileName= dataFilePath;
  SbFileName += file_name;
  FILE *fp;

  fp = SbFileHelper::open ( SbFileName, "r" );
  if (fp == NULL ) {
    printf ("file %s not found\n",SbFileName.toLatin1());
    exit(0);
  }

  fscanf (fp , "%d%d" , &num_triangles, &num_nodes);

  printf ("reading file %s %d triangles, %d vertices \n",file_name,num_triangles,num_nodes);

  int *tn = triangle_node = (int *)malloc(num_triangles*3*sizeof(int));
  for (i=0; i<num_triangles; i++) {
    int n0,n1,n2;
    fscanf (fp , "%d%d%d" , &n0,&n1,&n2);
    *tn++ = n0;
    *tn++ = n1;
    *tn++ = n2;
  }

  x = (float *)malloc(num_nodes*sizeof(float));
  y = (float *)malloc(num_nodes*sizeof(float));

  for (i=0; i<num_nodes; i++)fscanf (fp , "%f %f" , &x[i], &y[i]);
  printf ("end reading file \n\n");

}

/*---------------------------------------------------------------------- */
void read_val (const char *file_name, float *&v, float &vmin, float &vmax)
{
  int   i,np;
  SbString SbFileName= dataFilePath;
  SbFileName += file_name;
  FILE *fp;

  fp = SbFileHelper::open ( SbFileName , "r" );
  if (fp == NULL ) {
    printf ("file %s not found\n",file_name);
    exit(0);
  }

  fscanf (fp , "%d" , &np);
  v = (float *)malloc(np*sizeof(float));

  vmin = 1.E30F;
  vmax = -1.E30F;
  for (i=0; i<np; i++) {
    fscanf (fp , "%f " , &v[i]);
    if (v[i] < vmin) vmin = v[i];
    if (v[i] > vmax) vmax = v[i];
  }
  printf ("end reading file \n");
}

/*---------------------------------------------------------------------- */

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
  // initialize inventor classes
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;

  // initialize Master-Suite classes
  PoMeshViz::init() ;

  int num_nodes,num_triangles, *triangle_node;
  float *xm,*ym, *vm;
  float vmin, vmax;
  read_mesh("TRIANGLE.TOPO", num_nodes, xm,ym, num_triangles, triangle_node);
  read_val("TRIANGLE0.DAT", vm, vmin,vmax);

  // build the mesh object
  PoTriangleMesh2D *mesh = new PoTriangleMesh2D;
  mesh->setGeometry(num_nodes,xm,ym, num_triangles, triangle_node);

  // add a set of scalar values to this mesh
  mesh->addValuesSet(0,vm);

  // define a data-mapping associated to this data-set
  SbColor colors[5] = {SbColor(0.0,0.0,1.0), SbColor(0.0,1.0,1.0), SbColor(0.0,1.,0.), 
		       SbColor(1.0,1.0,0.0), SbColor(1.0,0.0,0.0)} ;
  float val[5];
  val[0] = vmin; for (int j=1; j<5; j++) val[j] = val[j-1] + (vmax-vmin)/4;
  PoNonLinearDataMapping2 *dataMapping = new PoNonLinearDataMapping2;
  dataMapping->value.setValues(0,5,val);
  dataMapping->color.setValues(0,5,colors);
  dataMapping->type = PoNonLinearDataMapping2::LINEAR_PER_LEVEL;

  // define the mesh edges
  PoMeshLines *meshLines = new PoMeshLines;
  meshLines->valuesIndex.setValue(0);
  meshLines->coloringType = PoMesh::COLOR_MAPPING;
   
  // build the scene-graph root
  SoGroup *root = new SoGroup;
  root->ref();
  root->addChild(dataMapping);
  root->addChild(mesh);
  root->addChild(meshLines);

  SoXtExaminerViewer *viewer = new SoXtExaminerViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setTitle("mesh lines");
  viewer->show();
  viewer->viewAll();

  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


