#define BUILDING_IN_DLL 1
#include "CellFilterIn.h"

#include <MeshViz/3Ddata/PbMesh.h>
#include <MeshViz/3Ddata/PbCell.h>

// CellFilterIn Class
SO_NODE_SOURCE(CellFilterIn) ;

void
CellFilterIn::initClass()
{
  SO_NODE_INIT_CLASS(CellFilterIn, PoCellFilter, "PoCellFilter") ;
}

void
CellFilterIn::exitClass()
{
  SO__NODE_EXIT_CLASS(CellFilterIn);
}

CellFilterIn::CellFilterIn()
{ 
  SO_NODE_CONSTRUCTOR(CellFilterIn) ;
}

CellFilterIn::~CellFilterIn()
{
}

void
CellFilterIn::setMesh (const PbMesh *pb_mesh) 
{
  m_mesh = pb_mesh;
  m_bbox = m_mesh->getBoundingBox();
}

void 
CellFilterIn::setBbox(SbBox3f bbox) 
{
    m_bbox = bbox;
}

void 
CellFilterIn::write(SoWriteAction *action) 
{
  PoNode::write(action);
}

SbBool 
CellFilterIn::acceptCell(int cell_index, float /*cell_value*/) const 
{
    const PbCell *cell = m_mesh->getCell( cell_index );
    return (m_bbox.intersect( cell->getCenter() ) );
}


