//****************************************************************************
//                                                                         
// demonstration class to visualize scalar data on a volume mesh 
// with 3D-Data-Master  
//                                                                         
//  author : J-Michel Godinaud                                             
//****************************************************************************

#ifndef CELL_FILTER_IN_H_
#define CELL_FILTER_IN_H_

#include <MeshViz/nodes/PoCellFilter.h>
#include <Inventor/SbBox.h>

// When building the node as a DLL under Win32 we must explicitly
// declare this entry point as visible outside the DLL.
// The macro BUILDING_DLL is defined in the node's source file.
#ifdef BUILDING_IN_DLL
  #define IN_EXPORT VC_DLL_EXPORT
#else
  #define IN_EXPORT VC_DLL_IMPORT
#endif

class PbMesh;

class IN_EXPORT CellFilterIn : public PoCellFilter 
{
  SO_NODE_HEADER(CellFilterIn);

public :

  CellFilterIn();
  ~CellFilterIn();

  static void initClass();
  static void exitClass();

  SbBool acceptCell(int cell_index, float cell_value) const;
  void setMesh (const PbMesh *pb_mesh);
  void setBbox(SbBox3f bbox);
  virtual void write(SoWriteAction *action);

protected:
  const PbMesh *m_mesh;
  SbBox3f      m_bbox;
  
};

#endif // CELL_FILTER_IN_H_


