#define BUILDING_OUT_DLL 1

#include "CellFilterOut.h"
#include <MeshViz/3Ddata/PbMesh.h>
#include <MeshViz/3Ddata/PbCell.h>

// CellFilterOut Class 
SO_NODE_SOURCE(CellFilterOut) ;

void
CellFilterOut::initClass()
{
  SO_NODE_INIT_CLASS(CellFilterOut, CellFilterIn, "CellFilterIn") ;
}

void
CellFilterOut::exitClass()
{
  SO__NODE_EXIT_CLASS(CellFilterOut);
}

CellFilterOut::CellFilterOut()
{
  SO_NODE_CONSTRUCTOR(CellFilterOut);
}

CellFilterOut::~CellFilterOut()
{
}

SbBool
CellFilterOut::acceptCell(int cell_index, float /*cell_value*/) const 
{
  const PbCell *cell = m_mesh->getCell(cell_index);

  return !(m_bbox.intersect(cell->getCenter()));
}


