//****************************************************************************
//                                                                         
// demonstration class to visualize scalar data on a volume mesh 
// with 3D-Data-Master  
//                                                                         
//  author : J-Michel Godinaud                                             
//****************************************************************************
#ifndef CELL_FILTER_OUT_H_
#define CELL_FILTER_OUT_H_

#include <MeshViz/nodes/PoCellFilter.h>
#include "CellFilterIn.h"

// When building the node as a DLL under Win32 we must explicitly
// declare this entry point as visible outside the DLL.
// The macro BUILDING_OUT_DLL is defined in the node's source file.
#ifdef BUILDING_OUT_DLL
  #define OUT_EXPORT VC_DLL_EXPORT
#else
  #define OUT_EXPORT VC_DLL_IMPORT
#endif

class OUT_EXPORT CellFilterOut : public CellFilterIn 
{
  SO_NODE_HEADER(CellFilterOut);

public :
  CellFilterOut();
  ~CellFilterOut();

  static void initClass();
  static void exitClass();
  SbBool acceptCell(int cell_index, float cell_value) const;
};

#endif //CELL_FILTER_OUT_H_


