//****************************************************************************
//                                                                         
// demonstration class to visualize scalar data on a volume mesh 
// with 3D-Data-Master  
//                                                                         
//  author : J-Michel Godinaud                                             
//****************************************************************************

#include <MeshViz/3Ddata/PbMesh3D.h>
#include <MeshViz/nodes/PoDomain.h>

#include <MeshViz/3Ddata/PoMeshSkin.h>
#include <MeshViz/3Ddata/PoMeshSkeleton.h>
#include <MeshViz/3Ddata/PoMeshLevelSurf.h>
#include <MeshViz/3Ddata/PoMeshCrossSection.h>
#include <MeshViz/3Ddata/PoMeshCrossContour.h>
#include <MeshViz/nodes/PoMeshProperty.h>

#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoClipPlane.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/draggers/SoJackDragger.h>
#include <Inventor/nodes/SoPickStyle.h>
#include <Inventor/sensors/SoOneShotSensor.h>

#include <DialogViz/SoDialogVizAll.h>

#include "MeshViewerComponent.h"

class CheckSwitchAuditor;
class CheckFieldConnectAuditor;
class TranspSliderAuditor;
class TranspTypeAuditor;
class CheckSwitchAuditor;
class CheckSwitchAuditor;
class CheckLinkAuditor;
class CheckSwitchAuditor;
class RealSliderAuditor;
class DataIsovalChoice;
class CheckSwitchAuditor;
class CheckAnimCoordAuditor;

/******************************************************************************/
//: Demonstration class to visualize scalar data on a volume mesh.
//   This is only a demonstration class, given with source code. 
//   As it uses only some of the features of 3D-data master, the limitations
//   of this class are not necessary limitation of 3D-data Master.
// 
//   This class is a part of the MeshViewer class. It cannot be instantiate
//   apart from MeshViewer. It controls the visualization of nodes that
//   depend on scalar data of a volume mesh (derived from PbMesh3D).
//
//   The associated dialog box controls 
//(      . the choice of a scalar data set used to compute a level surface.
//         (see PoMeshLevelSurf).
//       . the visibility and the value of this level surface.
//       . the visibility of the mesh skin (see PoMeshSkin).
//       . the visibility of the mesh skeleton (see PoMeshSkeleton).
//       . the visibility of a mesh cross contour (see PoMeshCrossContour).
//       . the visibility of a mesh cross section (see PoMeshCrossSection).
//       . the transparency of the skin.
//       . the activation of the clip plane (see SoClipPlane). When activated, 
//         the skin and the level surface are clipped.
//)
//   The position of the cross section, cross contour and clip plane are
//   relative to the position and orientation of the dragger. But this one
//   can be deconnected with a toggle button. In this case, the position 
//   of the cross section, cross contour and clip plane are not affected by
//   the motion of the dragger.
//    
/******************************************************************************/

class Mesh3DScalarViewer : public MeshViewerComponent {
public:
  Mesh3DScalarViewer(SoTopLevelDialog *dialogWindow, SoXtExaminerViewer *viewer);
    // Constructor.

  virtual ~Mesh3DScalarViewer();

  void buildSceneGraph(PoMeshProperty *mesh_node, PoDomain *domain, 
		       SoGroup *root,
		       SoSFInt32 *which_dataset,
		       SoSFEnum* &which_coloring_type);
    // Builds the scene graph parts corresponding to scalar data on the mesh

  SoDialogComponent *buildDialogBox (const PbMesh *);
    // Creates the dialog box.
  
  void updateAllConnectedToDragger(SoJackDragger *dragger, SbVec3f plane_normal);
    // When the dragger is connected, update the cross section, cross contour 
    // and clip plane.

  void preWriteAction();
    // Disables the field's connection during writing an Iv file

  void postWriteAction();
    // Re-enables the field's connection after writing an Iv file

  void setTransparencyValue(float val);
    // change the mesh skin level of transparency

  void setTransparencyType(SoGLRenderAction::TransparencyType type);
    // change the transparency type

  void setDatasetForLevelSurf(int datasetid);
    // change the dataset used by the levelsurf

  void startCoordAnimation();
  void stopCoordAnimation();

  void changeCoord();
private:
  void enableConnection(SoNode *node, SbBool flag);
  void changeCoord(const PbMesh *mesh);

  SoDialogGroup                   *v_DialogBox;

  PoMeshProperty                  *v_MeshProperty;

  PoMeshSkin                      *v_MeshSkin;
  PoMeshCrossSection              *v_MeshCrossSection;
  PoMeshSkeleton                  *v_MeshSkeleton;
  PoMeshLevelSurf                 *v_MeshLevelSurf;
  PoMeshCrossContour              *v_MeshCrossContour;

  SoClipPlane                    *v_ClipPlane;

  SoSwitch                       *v_MeshSkinSwitch;
  SoSwitch                       *v_MeshCrossSectionSwitch;
  SoSwitch                       *v_MeshSkeletonSwitch;
  SoSwitch                       *v_MeshLevelSurfSwitch;
  SoSwitch                       *v_MeshCrossContourSwitch;

  int                            v_DataSetIndex;
  int                            v_DataSetIndexOfLevelSurface;

  float                          v_TransparencyValue;
  SoGLRenderAction::TransparencyType v_TransparencyType;

  PoDomain                       *v_Domain;
  PbMesh                         *v_PbMesh;

  float                          *v_Vmin, *v_Vmax;
  int                            v_DataSetNum;
  char                           **v_DataSetNames;

  int                               v_animStep;
  float                            v_animScale;

  SbBool                         v_animateCoord;
  SbVec3f                        v_animCenter;

  SoXtExaminerViewer             *v_Viewer;
  SoTopLevelDialog               *v_DialogWindow;

  SoOneShotSensor                *v_sensor;

  CheckSwitchAuditor* m_skinCheckAud;
  CheckFieldConnectAuditor* m_skinColorCheckAud;
  TranspSliderAuditor* m_transpSliderAud;
  TranspTypeAuditor* m_transpTypeAud;
  CheckSwitchAuditor* m_crossSectionCheckAud;
  CheckSwitchAuditor*m_crossContourCheckAud ;
  CheckLinkAuditor* m_crossSectionLinkAud;
  CheckSwitchAuditor* m_levelSurfCheckAud;
  RealSliderAuditor* m_isovalSliderAud;
  DataIsovalChoice* m_dataIsovalChoiceAud;
  CheckSwitchAuditor* m_skeletonCheckAud;
  CheckAnimCoordAuditor* m_animCoordCheckAud;
};


