#include "MeshFilterViewer.h"
#include "commonAuditor.h"
#include <MeshViz/nodes/PoCellFilter.h>

class InOutChoice : public SoDialogChoiceAuditor {
  MeshFilterViewer *mViewer;
public:
  InOutChoice(MeshFilterViewer *mvw) { this->mViewer = mvw; }
  void dialogChoice (SoDialogChoice *dc) {
    mViewer->switchInOutFilter(dc->selectedItem.getValue());
  }
};

//-------------------------------------------------------------------------------------
MeshFilterViewer::~MeshFilterViewer()
{
  v_DialogBoxFilter->unref();
  CellFilterOut::exitClass();
  CellFilterIn::exitClass();
}

//-------------------------------------------------------------------------------------
void MeshFilterViewer::buildSceneGraph(const PbMesh *pb_mesh, 
                                       SoGroup *scene_filter)
{
  CellFilterIn::initClass();
  CellFilterOut::initClass();

  // setting OIV_USER_LIBS is usefull in case of ScaleViz or ART recording.
  SbString envVar = SbString("OIV_USER_LIBS");
  SbString currentValue = SoPreferences::getString("OIV_USER_LIBS", "");
  currentValue += ";$OIVHOME/$OIVARCH/Demos/MeshViz/CellFilterIn";
  currentValue += ";$OIVHOME/$OIVARCH/Demos/MeshViz/CellFilterOut";
  SoPreferences::setString("OIV_USER_LIBS", currentValue);

  v_cellFilterIn = new CellFilterIn();
  v_cellFilterOut = new CellFilterOut();

  v_cellFilterIn ->setMesh(pb_mesh);
  v_cellFilterOut->setMesh(pb_mesh);

  v_inOutFilterSwitch = new SoSwitch;
  v_inOutFilterSwitch->addChild(v_cellFilterIn);
  v_inOutFilterSwitch->addChild(v_cellFilterOut);
  v_inOutFilterSwitch->whichChild = 0;

  v_enableCellFilterSwitch = new SoSwitch;
  v_enableCellFilterSwitch->addChild(v_inOutFilterSwitch) ;
  v_enableCellFilterSwitch->whichChild = SO_SWITCH_NONE;

  SbBox3f bbox = pb_mesh->getBoundingBox();
  float sx,sy,sz;
  bbox.getSize(sx,sy,sz);
  v_BoxDragger = new SoHandleBoxDragger;
  v_BoxDragger->translation = bbox.getCenter();
  v_BoxDragger->scaleFactor.setValue(sx/5,sy/5,sz/1.5f);
  v_BoxDragger->addMotionCallback((SoDraggerCB *)&MeshFilterViewer::motionBoxCallback,this);
  setFilterBox(v_BoxDragger);

  v_BoxDraggerSwitch = new SoSwitch;
  v_BoxDraggerSwitch->addChild(v_BoxDragger) ;
  v_BoxDraggerSwitch->whichChild = SO_SWITCH_NONE;
  scene_filter->addChild(v_BoxDraggerSwitch);

  scene_filter->addChild(v_enableCellFilterSwitch);
}


//-------------------------------------------------------------------------------------
void MeshFilterViewer::motionBoxCallback(void *user_data, SoHandleBoxDragger *dragger) 
{
  MeshFilterViewer *viewer = (MeshFilterViewer *)user_data;
  viewer->setFilterBox(dragger);
}


//-------------------------------------------------------------------------------------
void MeshFilterViewer::setFilterBox(SoHandleBoxDragger *dragger) 
{
  SbVec3f center = dragger->translation.getValue();
  SbVec3f scale  = dragger->scaleFactor.getValue();
  SbVec3f bmin = center - scale*1;
  SbVec3f bmax = center + scale*1;
  
  v_cellFilterOut->setBbox(SbBox3f(bmin,bmax));
  v_cellFilterIn->setBbox(SbBox3f(bmin,bmax));
  v_cellFilterOut->touch();
  v_cellFilterIn->touch();
}


//-------------------------------------------------------------------------------------
SoDialogComponent *
MeshFilterViewer::buildDialogBox (const PbMesh* /*pb_mesh*/)
{
  SoInput myInput;
  if (!myInput.openFile( "$OIVHOME/examples/source/MeshViz/3Ddata/MeshViewer/GuiTabFilter.iv" ))
    exit (1);
  SoGroup *myGroup = SoDB::readAll( &myInput );
  if (myGroup == NULL)
    exit (1);
  v_DialogBoxFilter = (SoDialogGroup *)myGroup->getChild(0);
  v_DialogBoxFilter->ref();
  myGroup->ref();
  myGroup->unref();

  // box dragger check
  SoDialogCheckBox* boxCheck = (SoDialogCheckBox *)v_DialogBoxFilter->searchForAuditorId("BoxDraggerCheck");
  boxCheck->addAuditor(new CheckSwitchAuditor(v_BoxDraggerSwitch));
  boxCheck->state = (v_BoxDraggerSwitch->whichChild.getValue() != SO_SWITCH_NONE);

  // filter check
  SoDialogCheckBox* enableFilterCheck = (SoDialogCheckBox *)v_DialogBoxFilter->searchForAuditorId("EnableFilterCheck");
  enableFilterCheck->addAuditor(new CheckSwitchAuditor(v_enableCellFilterSwitch));
  enableFilterCheck->state = (v_enableCellFilterSwitch->whichChild.getValue() == SO_SWITCH_ALL);

  // In/out filter choice
  SoDialogChoice* inOutChoice = (SoDialogChoice *)v_DialogBoxFilter->searchForAuditorId("InOutFilter");
  inOutChoice->addAuditor(new InOutChoice(this));

  return v_DialogBoxFilter;
}


