//****************************************************************************
//                                                                         
// demonstration class to visualize scalar data on a volume mesh 
// with 3D-Data-Master  
//                                                                         
//  author : J-Michel Godinaud                                             
//****************************************************************************

#include <MeshViz/3Ddata/PbMesh3D.h>
#include <MeshViz/nodes/PoCellFilter.h>
#include <MeshViz/3Ddata/PbCell.h>

#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/draggers/SoTabBoxDragger.h>
#include <Inventor/draggers/SoHandleBoxDragger.h>

#include <DialogViz/SoDialogVizAll.h>
#include "MeshViewerComponent.h"

#include "CellFilterIn.h"
#include "CellFilterOut.h"

/******************************************************************************/
/******************************************************************************/
class MeshFilterViewer : public MeshViewerComponent {
public:

  virtual ~MeshFilterViewer();
    // Destructor.

  void buildSceneGraph(const PbMesh *mesh, SoGroup *root);

    // Builds the scene graph parts corresponding to scalar data on the mesh

  SoDialogComponent *buildDialogBox (const PbMesh *);
    // Creates the dialog box.
  
  void setFilterBox(SoHandleBoxDragger *dragger) ;

  void switchInOutFilter(int choice) {
    v_inOutFilterSwitch->whichChild = choice;
    v_cellFilterOut->touch();
    v_cellFilterIn->touch();
  }

private:
  SoDialogGroup                  *v_DialogBoxFilter;
  CellFilterIn                   *v_cellFilterIn;
  CellFilterOut                  *v_cellFilterOut;
  SoSwitch                       *v_BoxDraggerSwitch;
  SoSwitch                       *v_enableCellFilterSwitch;
  SoSwitch                       *v_inOutFilterSwitch;

  SoHandleBoxDragger             *v_BoxDragger;
  SoTopLevelDialog               *v_DialogWindow;

  static void motionBoxCallback(void *userData, SoHandleBoxDragger *dragger);
};


