////////////////////////////////
//
////////////////////////////////

#include "MeshViewer.h"
#include <MeshViz/nodes/PoRegularCartesianGrid2D.h>
#include <Inventor/helpers/SbFileHelper.h>

SbString dataFilePath = SbFileHelper::expandString("$OIVHOME/examples/data/MeshViz/");

int num_data_set;
int num_x, num_y;
float *v[20];
SbVec3f *vec;

/*----------------------------------------------------------------------------*/
void read_mesh(const char *filename)
{
  FILE *file_rep;
  SbString SbFileName= dataFilePath;
  SbFileName += filename;

  file_rep = SbFileHelper::open ( SbFileName , "r" );
  if (file_rep == NULL ) {
    printf ("file %s not found\n",SbFileName.toLatin1());
    exit(1);
  }
  int i;
  fscanf (file_rep , "%d%d" , &num_x, &num_y);
  float xmin,ymin, xmax,ymax;
  fscanf (file_rep , "%f %f %f %f", &xmin,&ymin, &xmax,&ymax);
  
  fscanf (file_rep , "%d", &num_data_set);
  
  int n, num_nodes;
  num_nodes = num_x*num_y;
  //  v = new (float *) [num_data_set];
  for (n=0; n<num_data_set; n++) {
    v[n] = new float [num_nodes];
    for (i=0; i<num_nodes; i++) 
      fscanf (file_rep , "%f", &v[n][i]);
  }

  int num_vec_set;
  fscanf (file_rep , "%d", &num_vec_set);
  float vx,vy,vz;
  vec = new SbVec3f [num_nodes];
  for (i=0; i<num_nodes; i++) {
    fscanf (file_rep , "%f %f %f", &vx,&vy,&vz);
    vec[i].setValue(vx,vy,vz);
  }
  
}/*---------------------------------------------------------------------------*/

int main(int, char **)
{
  read_mesh("METEO2D.DAT");

  // Initialize 3D-Master-Suite classes
  PoMeshViz::init() ;

  static const char *data_names[] = { 
    "the",
    "ect",
    "vect->u",
    "vect->v",
    "vect->w"
  };

  PoRegularCartesianGrid2D *mesh = new PoRegularCartesianGrid2D;
  mesh->setGeometry(num_x,num_y, 0,0, 50,50);

  for (int i=0; i<num_data_set; i++) 
    mesh->addValuesSet(i,v[i],data_names[i]);
  mesh->addVecsSet(0,vec);
  
  PoDomain *domain = new PoDomain;
  domain->min = SbVec3f(0,0,0);
  domain->max = SbVec3f(50,50,1);
  
  MeshViewer *mesh_viewer = new MeshViewer();
  mesh_viewer->setWindowTitle("Meteo2D");
  mesh_viewer->setCourtesyTitle("by courtesy of Meteo-France");
  mesh_viewer->setDataSetIndex(3);
  mesh_viewer->show(mesh,domain);

  delete mesh_viewer;

  PoMeshViz::finish();
  return 0;
}/*---------------------------------------------------------------------------*/


