////////////////////////////////
//
////////////////////////////////

#include "../TgsDemo.h"
#include "MeshViewer.h"
#include <MeshViz/nodes/PoCartesianGrid3D.h>
#include <Inventor/helpers/SbFileHelper.h>

SbString dataFilePath = SbFileHelper::expandString("$OIVHOME/examples/data/MeshViz/");

static const int num_data_set = 5;
static const int num_x=32,num_y=32,num_z=30;
float x[num_x][num_y][num_z], y[num_x][num_y][num_z], z[num_x][num_y][num_z];
float v[num_data_set][num_x][num_y][num_z];
SbVec3f vec[num_x][num_y][num_z];

#define PMIN(a,b) ((a)<(b)?(a):(b))
#define PMAX(a,b) ((a)>(b)?(a):(b))
/*---------------------------------------------------------------------- */

void 
read_topologie(const char *filnam, 
	       float &xmin, float &ymin, float &zmin, 
	       float &xmax, float &ymax, float &zmax )
{
  FILE *stream ;
  SbString SbFileName= dataFilePath;
  SbFileName += filnam;
  float xc ,yc ,dc ;
  int i ,j ,k ;
  
  dc = 625;

  xc = 0.0;
  for ( i=0; i<num_x; i++ ) {
    for ( j=0; j<num_y; j++ ) {
      for ( k=0; k<num_z; k++ ) {
        x[i][j][k] = xc;
      }
    }
    xc += dc;
  }
  xmin = 0. ;
  xmax = x[num_x-1][0][0] ;
  
  yc = 0.0;
  for ( j=0; j<num_y; j++ ) {
    for ( i=0; i<num_x; i++ ) {
      for ( k=0; k<num_z; k++ ) {
        y[i][j][k] = yc;
      }
    }
    yc += dc;
  }
  ymin = 0. ;
  ymax = y[0][num_y-1][0] ;
  
  printf ("start reading geometry file %s : %d %d %d\n", filnam, num_x, num_y, num_z);
  stream = SbFileHelper::open ( SbFileName , "r" );
  if ( stream == NULL ) { printf("file %s not found\n",SbFileName.toLatin1()); exit(1) ;}

  zmin =  1.E30F ;
  zmax = -1.E30F ;
  for ( k=0; k<num_z; k++ ) {
    for ( j=0; j<num_y; j++ ) {
      for ( i=0; i<num_x; i++ ) {
        fscanf(stream,"%f", &z[i][j][k] ) ;
        zmin = PMIN( zmin , z[i][j][k] ) ;
        zmax = PMAX( zmax , z[i][j][k] ) ;
      }
    }
  }

  fclose ( stream ) ;
  
}

/***************************************************************************/
void 
read_value(const char *filnam,int set_index)
{
  FILE *stream ;
  SbString SbFileName= dataFilePath;
  SbFileName += filnam;
  int i ,j ,k ;
  
  printf("Start reading file %s... \n", filnam);
  stream = SbFileHelper::open ( SbFileName, "r" );
  if ( stream == NULL ) { printf("file %s not found \n",SbFileName.toLatin1()); exit(1);}
  
  for ( k=0; k<num_z; k++ ) {
    for ( j=0; j<num_y; j++ ) {
      for ( i=0; i<num_x; i++ ) {
        fscanf( stream , "%f" , &v[set_index][i][j][k] ) ;
      }
    }
  } 

  fclose ( stream ) ;  

}

/*---------------------------------------------------------------------------*/

int
main(int, char **)
{
  FILE *f;
  f = SbFileHelper::open ("$OIVHOME/examples/data/MeshViz/poi3the32.txt" , "r" );
  if (f == NULL) {
    ShowMessage((char*)"Data file not found or not installed. \nYou may need to download the optional MeshViz data files. \n",
                (char*)"Machining");
    exit(1);
  }
  fclose(f);

  int i;
  static const char *data_names[] = { 
    "the",
    "ect",
    "vect->u",
    "vect->v",
    "vect->w"
  };

  float xmin,ymin,zmin, xmax,ymax,zmax;
  read_topologie("poi3z32.txt",xmin,ymin,zmin, xmax,ymax,zmax);
  read_value("poi3the32.txt",0);
  read_value("poi3ect32.txt",1);
  read_value("poi3u32.txt",2);
  read_value("poi3v32.txt",3);
  read_value("poi3w32.txt",4);

  // Initialize 3D-Master-Suite classes
  PoMeshViz::init() ;

  // Build a 3D grid mesh without duplicating the data set in memory
  PbCartesianGrid3D pb_mesh(num_x,num_y,num_z, x[0][0],y[0][0],z[0][0],FALSE);
  for (i=0; i<num_data_set; i++) pb_mesh.addValuesSet(i,v[i][0][0],data_names[i]);
  for (i=0; i<num_x; i++) for (int j=0; j<num_y; j++) for (int k=0; k<num_z; k++) {
    vec[i][j][k].setValue(v[2][i][j][k],v[3][i][j][k],v[4][i][j][k]);
  }
  pb_mesh.addVecsSet(0,vec[0][0]);

  PoCartesianGrid3D *mesh = new PoCartesianGrid3D;
  mesh->mesh.setValue(pb_mesh);

  MeshViewer *mesh_viewer = new MeshViewer();
  mesh_viewer->setWindowTitle("Meteorology");
  mesh_viewer->setCourtesyTitle("by courtesy of Meteo-France");
  mesh_viewer->show(mesh);
  delete mesh_viewer;

  PoMeshViz::finish();
  return 0;
}/*---------------------------------------------------------------------------*/


