#if defined(_WIN32)
#pragma warning(disable: 4996) // Disable PoXt deprecation warning
#endif

#include "Vec2DViewer.h"
#include <MeshViz/nodes/PoParalCartesianGrid2D.h>


#include <Inventor/SoWinApp.h>

int  main(int, char **)
{
  static const int num_x=3,num_y=3;
  static float x[num_x]= {0.0,0.5,1.0},  y[num_y] = {0.0,0.5,1.0};
  SbVec3f vec[num_x][num_y];
  static float val[num_x][num_y], alt[num_x][num_y];
  
  // initialize Master-Suite classes
  PoMeshViz::init() ;

  PoParalCartesianGrid2D *mesh = new PoParalCartesianGrid2D;
  mesh->setGeometry(num_x,num_y,x,y,FALSE);

  for (int i=0; i<num_x; i++) for (int j=0; j<num_y; j++) {
    val[i][j] = (float)(i * (num_y-j));
    alt[i][j] = 0.0;
    //    vec[i][j][k].setValue(0.3*(i+1), 0.4*(j+1), 0.5*(k+1));
    vec[i][j].setValue(0.05f*(j+1), 0.05f*(i+1), 0.0f);
  }
  alt[1][1] = 0.5f;

  mesh->addValuesSet(0,val[0]);
  mesh->addValuesSet(1,alt[0]);
  mesh->addVecsSet(0,vec[0]);

  Vec2DViewer* vec_viewer = new Vec2DViewer;
  vec_viewer->setTitle("PoParalCartesianGrid2D");
  vec_viewer->show(mesh);
  delete vec_viewer;

  PoMeshViz::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


