#if defined(_WIN32)
#pragma warning(disable: 4996) // Disable PoXt deprecation warning
#endif

#include "Vec3DViewer.h"
#include <MeshViz/nodes/PoParalCartesianGrid3D.h>


#include <Inventor/SoWinApp.h>

int  main(int, char **)
{
  static const int num_x=3,num_y=3,num_z=3;
  static float x[num_x]= {0.0,0.5,1.0},  y[num_y] = {0.0,0.5,1.0}, z[num_z]= {0.0,0.5,1.0};
  SbVec3f vec[num_x][num_y][num_z];
  float val[num_x][num_y][num_z];
  
  // initialize Master-Suite classes
  PoMeshViz::init() ;

  PoParalCartesianGrid3D *mesh = new PoParalCartesianGrid3D;
  mesh->setGeometry(num_x,num_y,num_z,x,y,z);

  for (int i=0; i<num_x; i++) for (int j=0; j<num_y; j++) for (int k=0; k<num_z; k++) {
    val[i][j][k] = (float)(i * (num_y-j) * k);
    vec[i][j][k].setValue(0.0125f*(j+1)*(num_z-k), 0.0125f*(i+1)*(k+1), 0.1f*(i+1));
  }

  mesh->addValuesSet(0,val[0][0]);
  mesh->addVecsSet(0,vec[0][0]);

  Vec3DViewer* vec_viewer = new Vec3DViewer;
  vec_viewer->setTitle("PoParalCartesianGrid3D");
  vec_viewer->show(mesh);
  delete vec_viewer;

  PoMeshViz::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


