////////////////////////////////
//
////////////////////////////////

#include "MeshViewer.h"
#include <MeshViz/nodes/PoPolarGrid2D.h>

/*----------------------------------------------------------------------------*/

void compute_geometry_and_val(int &nr, int &nt, float *&r, float *&t, float **v)
{
  int i;
  nr = 20; nt = 36;
  r = new float [nr];
  t = new float [nt];

  float rmax = 0.5;
  float rmin = rmax/nr;
  float dr = (rmax-rmin)/(nr-1);
  r[0] = rmin;
  for(i=1;i<nr;i++) r[i] = r[i-1]+dr;
  
#define ONE_DEGREE  0.017453293F
  float tmax = 280*ONE_DEGREE;
  float tmin = 0.0*ONE_DEGREE;
  float dt = (tmax-tmin)/(nt-1);
  t[0] = tmin;
  for(i=1;i<nt;i++) t[i] = t[i-1]+dt;

  int j;

  // data set 0
  v[0] = new float [nr*nt];
  for(i=0;i<nr;i++) for(j=0;j<nt;j++) v[0][i*nt+j] = r[i] + cos(t[j]);  
  
  // data set 1
  v[1] = new float [nr*nt];
  for(i=0;i<nr;i++) for(j=0;j<nt;j++) v[1][i*nt+j] = r[i] + sin(t[j]);  

  // data set 2
  v[2] = new float [nr*nt];
  for(i=0;i<nr;i++) for(j=0;j<nt;j++) v[2][i*nt+j] = exp(-r[i]) * sin(t[j])*cos(t[j]);

  // data set 3
  v[3] = new float [nr*nt];
  for(i=0;i<nr;i++) for(j=0;j<nt;j++) v[3][i*nt+j] = exp(-r[i]) * sin(t[j]) + cos(t[j]);

}/*---------------------------------------------------------------------------*/

int main(int, char **)
{
  int num_r, num_t;
  float *r, *t, *vm[4];
  compute_geometry_and_val(num_r,num_t, r,t, vm);

  // Initialize 3D-Master-Suite classes
  PoMeshViz::init() ;

  PoPolarGrid2D *mesh = new PoPolarGrid2D;
  mesh->setGeometry(num_r,num_t, r,t);
  for (int i=0; i<4; i++) mesh->addValuesSet(i,vm[i]);

  MeshViewer *mesh_viewer = new MeshViewer();
  mesh_viewer->setWindowTitle("PoPolarGrid2D");
  mesh_viewer->setDataSetIndex(1);
  mesh_viewer->show(mesh);
  delete mesh_viewer;

  PoMeshViz::finish();
  return 0;
}/*---------------------------------------------------------------------------*/


