#if defined(_WIN32)
#pragma warning(disable: 4996) // Disable PoXt deprecation warning
#endif

#include "Vec2DViewer.h"
#include <MeshViz/nodes/PoPolarGrid2D.h>


#include <Inventor/SoWinApp.h>

int  main(int, char **)
{
  static const int num_r=3,num_t=3;
  static float r[num_r]= {0.0,0.5,1.0},  t[num_t] = {0.0,0.5,1.0};
  SbVec3f vec[num_r][num_t];
  float val[num_r][num_t], alt[num_r][num_t];
  
  // initialize Master-Suite classes
  PoMeshViz::init() ;

  PoPolarGrid2D *mesh = new PoPolarGrid2D;
  mesh->setGeometry(num_r,num_t,r,t);

  for (int i=0; i<num_r; i++) for (int j=0; j<num_t; j++) {
    val[i][j] = (float)(i * (num_t-j));
    alt[i][j] = 0.0;
    vec[i][j].setValue(0.05f*(j+1), 0.05f*(i+1), 0);
  }
  alt[1][1] = 0.5f;

  mesh->addValuesSet(0,val[0]);
  mesh->addValuesSet(1,alt[0]);
  mesh->addVecsSet(0,vec[0]);

  Vec2DViewer* vec_viewer = new Vec2DViewer;
  vec_viewer->setTitle("PoPolarGrid2D");
  vec_viewer->show(mesh);
  delete vec_viewer;

  PoMeshViz::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


