#if defined(_WIN32)
#pragma warning(disable: 4996) // Disable PoXt deprecation warning
#endif

#include "Vec2DViewer.h"
#include <MeshViz/nodes/PoQuadrangleMesh2D.h>


#include <Inventor/SoWinApp.h>

int  main(int, char **)
{
  static const int num_nodes=8, num_elems=4;
  static float x[num_nodes] = {  0,1,4,5,4,1,2,3};
  static float y[num_nodes] = {  1,0,0,1,3,3,2,2};
  static int elem_index[] = {0,5,6,1, 1,6,7,2, 5,4,7,6, 4,3,2,7};

  static float val[num_nodes] = {0,1,1,2,5,2,6,9};
  static float alt[num_nodes] = {0,0,0,1,1,0,0,0};
  SbVec3f vec[num_nodes];
  vec[0].setValue(-0.5F,0.2F, 0.0F);
  vec[1].setValue(0.3F,-0.1F, 0.0F);
  vec[2].setValue(0.F, 0.2F, 0.0F);
  vec[3].setValue(-0.3F, 0.1F, 0.0F);
  vec[4].setValue(-0.3F, -0.1F, 0.0F);
  vec[5].setValue(0.3F,  0.2F, 0.0F);
  vec[6].setValue(-0.5F, -0.7F, 0.0F);
  vec[7].setValue(-0.1F,  0.4F, 0.0F);
  
  // initialize Master-Suite classes
  PoMeshViz::init() ;

  PoQuadrangleMesh2D *mesh = new PoQuadrangleMesh2D;
  mesh->setGeometry(num_nodes,x,y, num_elems, elem_index);
  
  mesh->addValuesSet(0,val);
  mesh->addValuesSet(1,alt);
  mesh->addVecsSet(0,vec);

  Vec2DViewer* vec_viewer = new Vec2DViewer;
  vec_viewer->setTitle("PoQuadrangleMesh2D");
  vec_viewer->show(mesh);
  delete vec_viewer;

  PoMeshViz::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


