////////////////////////////////
//
////////////////////////////////

#include "MeshViewer.h"
#include <MeshViz/nodes/PoRegularCartesianGrid2D.h>
#include <Inventor/helpers/SbFileHelper.h>

  SbString dataFilePath = SbFileHelper::expandString("$OIVHOME/examples/data/MeshViz/");


/*----------------------------------------------------------------------------*/
void read_mesh(const char *filename, int &num_x, int &num_y, 
	       float &xmin, float &ymin, float &xmax, float &ymax)
{
  FILE *file_rep;

  SbString SbFileName= dataFilePath;
  SbFileName += filename;

  file_rep = SbFileHelper::open ( SbFileName , "r" );
  if (file_rep == NULL ) {
    printf ("file %s not found\n",SbFileName.toLatin1());
    exit(1);
  }
  int nx,ny;
  float min,max;
  fscanf (file_rep , "%d%d" , &nx, &ny); num_x = nx; num_y = ny;
  fscanf(file_rep,"%f %f",&min,&max); xmin = min; xmax = max;
  fscanf(file_rep,"%f %f",&min,&max); ymin = min; ymax = max;
}/*---------------------------------------------------------------------------*/

void read_val(const char *filename, int num_val, float* &v)
{
  FILE *file_rep;
  SbString SbFileName= dataFilePath;
  SbFileName += filename;

  file_rep = SbFileHelper::open ( SbFileName , "r" );
  if (file_rep == NULL ) {
    printf ("file %s not found\n",SbFileName.toLatin1());
    exit(2);
  }

  v = new float [num_val];
  for (int i=0; i<num_val; i++) fscanf(file_rep,"%f",&v[i]);
}/*---------------------------------------------------------------------------*/


int main(int, char **) {
  int num_x,num_y;
  float xmin,ymin, xmax,ymax, *vm[4];

  read_mesh("REGULARGRID.TOPO", num_x, num_y, xmin,ymin, xmax,ymax);
  read_val("GRID0.DAT", num_x*num_y, vm[0]);
  read_val("GRID1.DAT", num_x*num_y, vm[1]);
  read_val("GRID2.DAT", num_x*num_y, vm[2]);
  read_val("GRID3.DAT", num_x*num_y, vm[3]);

  // Initialize 3D-Master-Suite classes
  PoMeshViz::init() ;

  PoRegularCartesianGrid2D *mesh = new PoRegularCartesianGrid2D;
  mesh->setGeometry(num_x,num_y, xmin,ymin, xmax,ymax);
  for (int i=0; i<4; i++) mesh->addValuesSet(i,vm[i]);

  PoDomain *domain = new PoDomain;
  domain->min = SbVec3f(xmin,ymin,0);
  domain->max = SbVec3f(xmax,ymax,1);
  
  MeshViewer *mesh_viewer = new MeshViewer();
  mesh_viewer->setWindowTitle("RegularCartesianGrid2D");
  mesh_viewer->setDataSetIndex(3);
  mesh_viewer->show(mesh,domain);
  delete mesh_viewer;

  PoMeshViz::finish();
  return 0;
}/*---------------------------------------------------------------------------*/


