////////////////////////////////
// 
////////////////////////////////

#include "MeshViewer.h"
#include <MeshViz/nodes/PoRegularCartesianGrid3D.h>

static const int num_data_set = 15;
static const int num_x=30,num_y=30,num_z=30;
float v[num_data_set][num_x][num_y][num_z];

/*---------------------------------------------------------------------- */
void compute_data (float xmin, float ymin, float zmin, 
                   float xmax, float ymax, float zmax)
{
  float x[num_x], y[num_y], z[num_z];
  float         xc,yc,zc;
  int           i,j,k;

  for ( i=0 ;i < num_x ;i++ ) x[i] = xmin + i*(xmax-xmin)/(num_x-1);
  for ( i=0 ;i < num_y ;i++ ) y[i] = ymin + i*(ymax-ymin)/(num_y-1);
  for ( i=0 ;i < num_z ;i++ ) z[i] = zmin + i*(zmax-zmin)/(num_z-1);

  for ( i=0 ;i < num_x ;i++ ) {
    xc = x[i]*x[i];
    for (j=0 ;j < num_y ;j++ ) {
      yc = y[j]*y[j];
      for ( k=0 ;k < num_z ;k++ ) {
	zc = z[k]*z[k];
	v[0][i][j][k] = xc + yc + zc;
      }
    }
  }

  for ( i=0 ;i < num_x ;i++ ) {
    xc = x[i]*x[i];
    for (j=0 ;j < num_y ;j++ ) {
      yc = y[j];
      for ( k=0 ;k < num_z ;k++ ) {
	zc = z[k]*z[k]*z[k];
	v[1][i][j][k] = xc + yc + zc;
      }
    }
  }

  for ( i=0 ;i < num_x ;i++ ) {
    xc = x[i]*x[i];
    for (j=0 ;j < num_y ;j++ ) {
      yc = 5*y[j];
      for ( k=0 ;k < num_z ;k++ ) {
	zc = z[k]*z[k];
	v[2][i][j][k] = xc + yc + zc;
      }
    }
  }

  for ( i=0 ;i < num_x ;i++ ) {
    xc = x[i]*x[i];
    for (j=0 ;j < num_y ;j++ ) {
      yc = y[j]*y[j]*y[j];
      for ( k=0 ;k < num_z ;k++ ) {
	zc = z[k]*z[k];
	v[3][i][j][k] = xc + yc + zc*zc;
      }
    }
  }

  for ( i=0 ;i < num_x ;i++ ) {
    xc = x[i]*x[i];
    for (j=0 ;j < num_y ;j++ ) {
      yc = y[j];
      for ( k=0 ;k < num_z ;k++ ) {
	zc = z[k];
	v[4][i][j][k] = xc*yc + zc;
      }
    }
  }

  for ( i=0 ;i < num_x ;i++ ) {
    xc = x[i]*x[i];
    for (j=0 ;j < num_y ;j++ ) {
      yc = y[j]*y[j];
      for ( k=0 ;k < num_z ;k++ ) {
	zc = z[k];
	v[5][i][j][k] = xc*yc + zc*x[i];
      }
    }
  }

  for ( i=0 ;i < num_x ;i++ ) {
    xc = x[i];
    for (j=0 ;j < num_y ;j++ ) {
      yc = y[j];
      for ( k=0 ;k < num_z ;k++ ) {
	zc = z[k];
	v[6][i][j][k] = xc*yc*zc;
      }
    }
  }

  for ( i=0 ;i < num_x ;i++ ) {
    xc = cos ( x[i] );
    for (j=0 ;j < num_y ;j++ ) {
      yc = sin ( y[j] );
      for ( k=0 ;k < num_z ;k++ ) {
	zc = sin ( z[k] );
	v[7][i][j][k] = xc + yc + zc*zc;
      }
    }
  }

  for ( i=0 ;i < num_x ;i++ ) {
    xc = cos ( x[i] );
    for (j=0 ;j < num_y ;j++ ) {
      yc = cos ( y[j] );
      for ( k=0 ;k < num_z ;k++ ) {
	zc = sin ( z[k] );
	v[8][i][j][k] = xc + yc + zc;
      }
    }
  }

  for ( i=0 ;i < num_x ;i++ ) {
    xc = cos ( x[i] );
    for (j=0 ;j < num_y ;j++ ) {
      yc = cos ( y[j] );
      for ( k=0 ;k < num_z ;k++ ) {
	zc = sin ( z[k] );
	v[9][i][j][k] = xc * yc * zc;
      }
    }
  }

  for ( i=0 ;i < num_x ;i++ ) {
    xc = cos ( x[i] );
    xc = xc*xc ;
    for (j=0 ;j < num_y ;j++ ) {
      yc = sin ( y[j] );
      yc = yc*yc ;
      for ( k=0 ;k < num_z ;k++ ) {
	v[10][i][j][k] = xc + yc;
      }
    }
  }

  for ( i=0 ;i < num_x ;i++ ) {
    xc = cos ( x[i] );
    xc = xc*xc ;
    for (j=0 ;j < num_y ;j++ ) {
      yc = sin ( y[j] );
      yc = yc*yc ;
      for ( k=0 ;k < num_z ;k++ ) {
	zc = cos ( z[k] );
	v[11][i][j][k] = xc + yc + zc*zc;
      }
    }
  }

  for ( i=0 ;i < num_x ;i++ ) {
    xc = x[i];
    xc = xc*cos ( xc );
    for (j=0 ;j < num_y ;j++ ) {
      yc = y[j];
      yc = yc*sin ( yc );
      for ( k=0 ;k < num_z ;k++ ) {
	zc = cos ( z[k] );
	v[12][i][j][k] = xc + yc + zc*zc;
      }
    }
  }

  for ( i=0 ;i < num_x ;i++ ) {
    xc = x[i];
    xc = xc*cos ( xc );
    for (j=0 ;j < num_y ;j++ ) {
      yc = y[j];
      yc = yc*sin ( yc );
      for ( k=0 ;k < num_z ;k++ ) {
	zc = z[k] * cos ( z[k] );
	v[13][i][j][k] = xc + yc + zc;
      }
    }
  }

  for ( i=0 ;i < num_x ;i++ ) {
    xc = x[i];
    for (j=0 ;j < num_y ;j++ ) {
      yc = y[j];
      for ( k=0 ;k < num_z ;k++ ) {
	zc = z[k];
	v[14][i][j][k] = xc*xc*xc + yc*yc*yc + zc*zc*zc -2.0f*xc*yc*zc;
      }
    }
  }

}

/*---------------------------------------------------------------------------*/


int main(int, char **) {
  static const char *data_names[num_data_set] = { 
    "F1  = X*X + Y*Y + Z*Z                  "
    ,"F2  = X*X + Y + Z*Z*Z                  "
    ,"F3  = X*X + 5Y + Z*Z                   " 
    ,"F4  = X*X + Y*Y*Y + Z*Z*Z*Z            "
    ,"F5  = X*X*Y + Z                        " 
    ,"F6  = X*X*Y*Y + Z*X                    "
    ,"F7  = X*Y*Z                            " 
    ,"F8  = CosX + SinY + SinZ*SinZ          "
    ,"F9  = CosX + CosY + SinZ               " 
    ,"F10 = CosX * CosY * SinZ               "
    ,"F11 = CosX*CosX  + SinY*SinY           " 
    ,"F12 = CosX*CosX + SinY*SinY + CosZ*CosZ"
    ,"F13 = XCosX  + YSinY + CosZ*CosZ       " 
    ,"F14 = XCosX  + YSinY + ZCosZ           " 
    ,"F15 = X*X*X + Y*Y*Y + Z*Z*Z -2X*Y*Z    " 
  };

  compute_data(-2,-2,-2, 2,2,2);

  // Initialize 3D-Master-Suite classes
  PoMeshViz::init() ;

  // Build a 3D grid mesh without duplicating the data set in memory
  PbRegularCartesianGrid3D pb_mesh(num_x,num_y,num_z, -2,-2,-2, 2,2,2, FALSE);
  for (int i=0; i<num_data_set; i++) pb_mesh.addValuesSet(i,v[i][0][0],data_names[i]);

  PoRegularCartesianGrid3D *mesh = new PoRegularCartesianGrid3D;
  mesh->mesh.setValue(pb_mesh);

  MeshViewer *mesh_viewer = new MeshViewer();
  mesh_viewer->setWindowTitle("PbRegularCartesianGrid3D");
  mesh_viewer->show(mesh);
  delete mesh_viewer;

  PoMeshViz::finish();
  return 0;
}/*---------------------------------------------------------------------------*/


  


