////////////////////////////////

#include "../TgsDemo.h"
#include "MeshViewer.h"
#include <MeshViz/nodes/PoTetrahedronMesh3D.h>
#include <Inventor/SoPreferences.h>
#include <Inventor/helpers/SbFileHelper.h>

SbString dataFilePath = SbFileHelper::expandString("$OIVHOME/examples/data/MeshViz/");


/*---------------------------------------------------------------------- */

void read_mesh (const char *file_name, 
		int &num_nodes, 
		float *&x, float *&y, float *&z, 
		float **vm, SbVec3f *&vec, 
		int &num_tetrahedrons, int *&tetrahedron_node)
{
  int   i;
  FILE *fp;
  SbString SbFileName= dataFilePath;
  SbFileName += file_name;
  fp = SbFileHelper::open (SbFileName , "r" );
  if (fp == NULL ) {
    printf ("file %s not found\n",SbFileName.toLatin1());
    exit(0);
  }

  fscanf (fp , "%d%d" , &num_nodes, &num_tetrahedrons);

  printf ("   num nodes       %d\n",num_nodes);
  printf ("   num tetahedrons %d\n",num_tetrahedrons);

  printf ("reading nodes coordinates\n");
  x = new float [num_nodes];
  y = new float [num_nodes];
  z = new float [num_nodes];
  for (i=0; i<num_nodes; i++) fscanf(fp, "%e%e%e", &x[i], &y[i], &z[i]);

  printf ("reading nodes vectors\n");
  vec = new SbVec3f [num_nodes];
  float vx,vy,vz;
  for (i=0; i<num_nodes; i++) {
    fscanf(fp, "%e%e%e", &vx, &vy, &vz);
    vec[i].setValue(vx,vy,vz);
  }

  printf ("reading value\n");
  vm[0] = new float [num_nodes];
  for (i=0; i<num_nodes; i++) fscanf (fp , "%f " , &vm[0][i]);

  vm[1] = new float [num_nodes];
  for (i=0; i<num_nodes; i++) fscanf (fp , "%f " , &vm[1][i]);

  vm[2] = new float [num_nodes];
  for (i=0; i<num_nodes; i++) fscanf (fp , "%f " , &vm[2][i]);

  vm[3] = new float [num_nodes];
  for (i=0; i<num_nodes; i++) fscanf (fp , "%f " , &vm[3][i]);

  int c;
  for (i=0; i<num_nodes; i++) fscanf(fp, "%d", &c);

  printf ("reading tetahedrons nodes indices\n");
  int *tn = tetrahedron_node = new int [num_tetrahedrons*4];
  for (i=0; i<num_tetrahedrons; i++) {
    int n0,n1,n2,n3;
    fscanf (fp , "%d%d%d%d" , &n0,&n1,&n2,&n3);
    *tn++ = n0;
    *tn++ = n2;
    *tn++ = n1;
    *tn++ = n3;
  }

  printf ("end reading file \n\n");

}/*---------------------------------------------------------------------------*/

int main(int, char **) {
  FILE *f;

  f = SbFileHelper::open ( "$OIVHOME/examples/data/MeshViz/poi3u32.txt" , "r" );
  if (f == NULL) {
    ShowMessage((char*)"Data file not found or not installed. \nYou may need to download the optional MeshViz data files. \n",
                (char*)"TetrahedronMesh3D");
    exit(1);
  }
  fclose(f);
  static const char *data_names[] = { "pressure","k-turbulent","k-epsilon","viscosity"};
  int num_nodes,num_tetrahedrons, *tetrahedron_node;
  float *xm,*ym,*zm, *vm[4];
  SbVec3f *vec;

  read_mesh("MESH_TETR.DAT", num_nodes, xm,ym,zm,vm, vec, num_tetrahedrons, tetrahedron_node);
  
  // Initialize MeshViz classes
  PoMeshViz::init() ;

  // Build a 3D mesh without duplicating the data set in memory
  PbTetrahedronMesh3D* pb_mesh = new PbTetrahedronMesh3D(num_nodes,xm,ym,zm, num_tetrahedrons, tetrahedron_node,FALSE);
  for (int i=0; i<4; i++)
    pb_mesh->addValuesSet(i,vm[i],data_names[i]);
  pb_mesh->addVecsSet(0,vec);
  
  PoTetrahedronMesh3D *mesh = new PoTetrahedronMesh3D;
  mesh->ref();
  mesh->mesh.setValue( *pb_mesh );

  MeshViewer *mesh_viewer = new MeshViewer();
  mesh_viewer->setWindowTitle("PbTetrahedronMesh3D");
  mesh_viewer->setCourtesyTitle("by courtesy of EDF");
  mesh_viewer->setDraggerNormal(SbVec3f(1,0,0));
  mesh_viewer->show(mesh);
  delete mesh_viewer;

  mesh->unref();
  PoMeshViz::finish();
  delete pb_mesh;
  delete [] vm[0];
  delete [] vm[1];
  delete [] vm[2];
  delete [] vm[3];
  delete [] xm;
  delete [] ym;
  delete [] zm;
  delete [] vec;
  delete [] tetrahedron_node;
  return 0;
}/*---------------------------------------------------------------------------*/


