#if defined(_WIN32)
#pragma warning(disable: 4996) // Disable PoXt deprecation warning
#endif

#include "Vec3DViewer.h"
#include <MeshViz/nodes/PoTetrahedronMesh3D.h>


#include <Inventor/SoWinApp.h>

int  main(int, char **)
{
  static const int num_nodes=5, num_elems=2;
  static float x[num_nodes] = {  0,1,-1,0, 2};
  static float y[num_nodes] = {  0,0,0,2, 0};
  static float z[num_nodes] = {  1,-1,0,0, 1};
  static int elem_index[] = {0,2,1,3, 0,1,4,3};

  static float val[num_nodes] = {0,1,1,2,5};
  SbVec3f vec[num_nodes];
  vec[0].setValue(0.1F,0.2F,0.3F);
  vec[1].setValue(0.3F,-0.1F,0.2F);
  vec[2].setValue(0.F, 0.2F, -0.5F);
  vec[3].setValue(-0.3F, 0.1F, 0.2F);
  vec[4].setValue(-0.3F, -0.1F, 0.3F);
  
  // initialize Master-Suite classes
  PoMeshViz::init() ;

  PoTetrahedronMesh3D *mesh = new PoTetrahedronMesh3D;
  mesh->setGeometry(num_nodes,x,y,z, num_elems, elem_index);
  mesh->addValuesSet(0,val);
  mesh->addVecsSet(0,vec);

  Vec3DViewer* vec_viewer = new Vec3DViewer;
  vec_viewer->setTitle("PoTetrahedronMesh3D");
  vec_viewer->show(mesh);
  delete vec_viewer;

  PoMeshViz::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


