////////////////////////////////
//
////////////////////////////////

#include "MeshViewer.h"
#include <MeshViz/nodes/PoTriangleMesh2D.h>
#include <Inventor/helpers/SbFileHelper.h>

SbString dataFilePath = SbFileHelper::expandString("$OIVHOME/examples/data/MeshViz/");

/*---------------------------------------------------------------------- */

void read_mesh (const char *file_name, 
                int &num_nodes, 
                float *&x, float *&y, 
                int &num_triangles, int *&triangle_node)
{
  int   i;
  FILE *fp;
  SbString SbFileName= dataFilePath;
  SbFileName += file_name;
  fp = SbFileHelper::open ( SbFileName , "r" );
  if (fp == NULL ) {
    printf ("file %s not found\n",SbFileName.toLatin1());
    exit(0);
  }

  fscanf (fp , "%d%d" , &num_triangles, &num_nodes);

  printf ("reading file %s %d triangles, %d vertices \n",file_name,num_triangles,num_nodes);

  int *tn = triangle_node = new int [num_triangles*3];
  for (i=0; i<num_triangles; i++) {
    int n0,n1,n2;
    fscanf (fp , "%d%d%d" , &n0,&n1,&n2);
    *tn++ = n0;
    *tn++ = n1;
    *tn++ = n2;
  }

  x = new float [num_nodes];
  y = new float [num_nodes];

  for (i=0; i<num_nodes; i++)fscanf (fp , "%f %f" , &x[i], &y[i]);
  printf ("end reading file \n\n");

}

/*---------------------------------------------------------------------- */
void read_val (const char *file_name, float *&v)
{
  int   i,np;
  FILE *fp;
  SbString SbFileName= dataFilePath;
  SbFileName += file_name;
  fp = SbFileHelper::open ( SbFileName , "r" );
  if (fp == NULL ) {
    printf ("file %s not found\n",SbFileName.toLatin1());
    exit(0);
  }

  fscanf (fp , "%d" , &np);
  v = new float [np];

  for (i=0; i<np; i++) fscanf (fp , "%f " , &v[i]);
  printf ("end reading file \n");
}
/*---------------------------------------------------------------------- */

int main(int, char **) {

  int num_nodes,num_triangles, *triangle_node;
  float *xm,*ym, *vm[4];

  read_mesh("TRIANGLE.TOPO", num_nodes, xm,ym, num_triangles, triangle_node);
  read_val("TRIANGLE0.DAT", vm[0]);
  read_val("TRIANGLE1.DAT", vm[1]);
  read_val("TRIANGLE2.DAT", vm[2]);
  read_val("TRIANGLE3.DAT", vm[3]);

  // Initialize 3D-Master-Suite classes
  PoMeshViz::init() ;

  PoTriangleMesh2D *mesh = new PoTriangleMesh2D;
  mesh->setGeometry(num_nodes,xm,ym, num_triangles, triangle_node);
  for (int i=0; i<4; i++) mesh->addValuesSet(i,vm[i]);

  const PbTriangleMesh2D* pb_mesh = (const PbTriangleMesh2D *)mesh->getMesh();
  SbVec2f min,max;
  pb_mesh->getBoundingBox().getBounds(min, max);

  // set the domain to the smallest square surrounding the mesh
  PoDomain *domain = new PoDomain;
  domain->setValues(min,max,PoDomain::MIN_BOUNDING_CUBE);

  MeshViewer *mesh_viewer = new MeshViewer();
  mesh_viewer->setWindowTitle("Triangle mesh");
  mesh_viewer->setDataSetIndex(3);
  mesh_viewer->show(mesh, domain);
  delete mesh_viewer;

  PoMeshViz::finish();
  return 0;
}/*---------------------------------------------------------------------------*/


















