#if defined(_WIN32)
#pragma warning(disable: 4996) // Disable PoXt deprecation warning
#endif

#include "Vec2DViewer.h"
#include <MeshViz/nodes/PoTriangleMesh2D.h>


#include <Inventor/SoWinApp.h>

int  main(int, char **)
{
  static const int num_nodes=5, num_elems=3;
  static float x[num_nodes] = {  0,0,2,2,1};
  static float y[num_nodes] = {  0,2,2,0,1};
  static int elem_index[] = {0,1,4, 4,2,3, 1,2,4};

  static float val[num_nodes] = {0,1,1,2,5};
  static float alt[num_nodes] = {0,1,1,0,0};
  SbVec3f vec[num_nodes];
  vec[0].setValue(0.1F,0.2F, 0.0F);
  vec[1].setValue(0.3F,-0.1F, 0.0F);
  vec[2].setValue(0.F, 0.2F, 0.0F);
  vec[3].setValue(-0.3F, 0.1F, 0.0F);
  vec[4].setValue(-0.3F, -0.1F, 0.0F);
  
  // initialize Master-Suite classes
  PoMeshViz::init() ;

  PoTriangleMesh2D *mesh = new PoTriangleMesh2D;
  mesh->setGeometry(num_nodes,x,y, num_elems, elem_index);
  mesh->addValuesSet(0,val);
  mesh->addValuesSet(1,alt);
  mesh->addVecsSet(0,vec);

  Vec2DViewer* vec_viewer = new Vec2DViewer;
  vec_viewer->setTitle("PoTriangleMesh2D");
  vec_viewer->show(mesh);
  delete vec_viewer;

  PoMeshViz::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


