////////////////////////////////
//
////////////////////////////////

#include "../TgsDemo.h"
#include "MeshViewer.h"
#include <MeshViz/nodes/PoParalCartesianGrid2D.h>

#include <Inventor/helpers/SbFileHelper.h>

  SbString dataFilePath = SbFileHelper::expandString("$OIVHOME/examples/data/MeshViz/");


/*----------------------------------------------------------------------------*/
void read_mesh(const char *filename, int &nx, float* &x, int &ny, float* &y) 
{
  FILE *file_rep;
  
  SbString SbFileName= dataFilePath;
  SbFileName += filename;
  file_rep = SbFileHelper::open (SbFileName , "r" );
  if (file_rep == NULL ) {
    printf ("file %s not found\n",SbFileName.toLatin1());
    exit(1);
  }
  int i,num_x,num_y;
  fscanf (file_rep , "%d%d" , &num_x, &num_y);
  nx = num_x;
  ny = num_y;
  
  x = new float [num_x];
  y = new float [num_y];
  for (i=0; i<num_x; i++) fscanf(file_rep,"%f",&x[i]);
  for (i=0; i<num_y; i++) fscanf(file_rep,"%f",&y[i]);
}/*---------------------------------------------------------------------------*/

void read_val(const char *filename, int num_val, float* &v)
{
  FILE *file_rep;

  SbString SbFileName= dataFilePath;
  SbFileName += filename;
  file_rep =  SbFileHelper::open(SbFileName , "r" );
  if (file_rep == NULL ) {
    printf ("file %s not found\n",SbFileName.toLatin1());
    exit(2);
  }

  v = new float [num_val];
  for (int i=0; i<num_val; i++) fscanf(file_rep,"%f",&v[i]);
}/*---------------------------------------------------------------------------*/


int main(int, char **) {

  FILE *f;
  f = SbFileHelper::open ( "$OIVHOME/examples/data/MeshViz/poi3u32.txt" , "r" );
  if (f == NULL) {
    ShowMessage((char*)"Data file not found or not installed. \nYou may need to download the optional MeshViz data files. \n",
                (char*)"");
    exit(1);
  }
  fclose(f);

  int num_x,num_y;
  float *xm,*ym, *vm[4];

  read_mesh("UNDEFGRID.TOPO", num_x, xm, num_y, ym) ;
  read_val("IDESUNI.DAT", num_x*num_y, vm[0]);
  read_val("IGEOMET.DAT", num_x*num_y, vm[1]);

  // Initialize 3D-Master-Suite classes
  PoMeshViz::init() ;

  PoParalCartesianGrid2D *mesh = new PoParalCartesianGrid2D;
  mesh->setGeometry(num_x, num_y, xm,ym);
  for (int i=0; i<2; i++) mesh->addValuesSet(i,vm[i]);

  PoDomain *domain = new PoDomain;
  domain->min = SbVec3f(xm[0],ym[0],0);
  domain->max = SbVec3f(xm[num_x-1],ym[num_y-1],0);

  MeshViewer *mesh_viewer = new MeshViewer();
  mesh_viewer->setWindowTitle("UndefValMesh2D");
  mesh_viewer->enableMaxThreshold(TRUE);
  mesh_viewer->show(mesh,domain);
  delete mesh_viewer;

  PoMeshViz::finish();
  return 0;
}/*---------------------------------------------------------------------------*/


