#include "Vec2DViewer.h"

#include <DialogViz/SoDialogVizAll.h>

class WriteAuditor : public SoDialogPushButtonAuditor
{
  SoSeparator* v_Root;

public:
  WriteAuditor(SoSeparator* root) : v_Root(root)
  {}

  void dialogPushButton(SoDialogPushButton* /*cpt*/)
  {
    char filename[80];
    SoWriteAction myAction;
    myAction.getOutput()->openFile( strcat( strcpy( filename, "3D_mesh_viewer" ), ".iv" ) );
    myAction.getOutput()->setBinary( FALSE );
    myAction.apply( v_Root );
    myAction.getOutput()->closeFile();
  }
};

class SwitchLinesAuditor : public SoDialogCheckBoxAuditor
{
  SoSwitch* v_MeshSkinSwitch;
public:
  SwitchLinesAuditor(SoSwitch* meshSkinSwitch) : v_MeshSkinSwitch(meshSkinSwitch)
  { }

  void dialogCheckBox(SoDialogCheckBox* /*cpt*/)
  {
    if ( v_MeshSkinSwitch->whichChild.getValue() == SO_SWITCH_ALL )
      v_MeshSkinSwitch->whichChild = SO_SWITCH_NONE;
    else
      v_MeshSkinSwitch->whichChild = SO_SWITCH_ALL;
  }
};

class SwitchVecSkinAuditor : public SoDialogCheckBoxAuditor
{
  SoSwitch* v_MeshVecFieldSwitch;
public:
  SwitchVecSkinAuditor(SoSwitch* meshVecFieldSwitch) : v_MeshVecFieldSwitch(meshVecFieldSwitch)
  { }

  void dialogCheckBox(SoDialogCheckBox* /*cpt*/)
  {
    if (v_MeshVecFieldSwitch->whichChild.getValue() == SO_SWITCH_ALL)
      v_MeshVecFieldSwitch->whichChild = SO_SWITCH_NONE;
    else
      v_MeshVecFieldSwitch->whichChild = SO_SWITCH_ALL;
  }
};

class SliderDensityAuditor : public SoDialogIntegerSliderAuditor
{
  PoMesh2DVec* v_MeshVecField;
public:
  SliderDensityAuditor(PoMesh2DVec* meshVecField) : v_MeshVecField(meshVecField)
  { }

  void dialogIntegerSlider(SoDialogIntegerSlider* cpt)
  {
    v_MeshVecField->density = cpt->value.getValue();
  }
};

class ChoiceEliminationAuditor : public SoDialogChoiceAuditor
{
  PoMesh2DVec* v_MeshVecField;
public:
  ChoiceEliminationAuditor(PoMesh2DVec* meshVecField) : v_MeshVecField(meshVecField)
  {}

  void
  dialogChoice( SoDialogChoice* cpt )
  {
    // change eliminate type
    switch ( cpt->selectedItem.getValue() )
    {
    case 0:
      v_MeshVecField->eliminationStatus = PoMesh2DVec::NONE;
      break;
    case 1:
      v_MeshVecField->eliminationStatus = PoMesh2DVec::TOO_SMALL;
      break;
    case 2:
      v_MeshVecField->eliminationStatus = PoMesh2DVec::TOO_LONG;
      break;
    case 3:
      v_MeshVecField->eliminationStatus = PoMesh2DVec::TOO_SMALL_OR_LONG;
      break;
    default:
      break;
    }
  }
};

class SliderMinLengthAuditor : public SoDialogRealSliderAuditor
{
  PoMesh2DVec* v_MeshVecField;
public:
  SliderMinLengthAuditor(PoMesh2DVec* meshVecField) : v_MeshVecField(meshVecField)
  { }

  void dialogRealSlider(SoDialogRealSlider* cpt)
  {
    v_MeshVecField->minLength = cpt->value.getValue();
  }
};

class SliderMaxLengthAuditor : public SoDialogRealSliderAuditor
{
  PoMesh2DVec* v_MeshVecField;
public:
  SliderMaxLengthAuditor(PoMesh2DVec* meshVecField) : v_MeshVecField(meshVecField)
  { }

  void dialogRealSlider(SoDialogRealSlider* cpt)
  {
    v_MeshVecField->maxLength = cpt->value.getValue();
  }
};

class BodyTypeAuditor : public SoDialogChoiceAuditor
{
  PoMesh2DVec* v_MeshVecField;
public:
  BodyTypeAuditor(PoMesh2DVec* meshVecField) : v_MeshVecField(meshVecField)
  {}

  void
  dialogChoice( SoDialogChoice* cpt )
  {
    switch ( cpt->selectedItem.getValue() )
    {
    case 0:
      v_MeshVecField->bodyShape = PoMesh2DVec::NO_BODY;
      break;
    case 1:
      v_MeshVecField->bodyShape = PoMesh2DVec::LINE;
      break;
    case 2:
      v_MeshVecField->bodyShape = PoMesh2DVec::CYLINDER;
      break;
    default:
      break;
    }
  }
};

class BodyLenTypeAuditor : public SoDialogChoiceAuditor
{
  PoMesh2DVec* v_MeshVecField;
public:
  BodyLenTypeAuditor(PoMesh2DVec* meshVecField) : v_MeshVecField(meshVecField)
  {}

  void
  dialogChoice( SoDialogChoice* cpt )
  {
    switch ( cpt->selectedItem.getValue() )
    {
    case 0:
      v_MeshVecField->bodyLengthType = PoMesh2DVec::CONSTANT_LENGTH;
      break;
    case 1:
      v_MeshVecField->bodyLengthType = PoMesh2DVec::RELATIVE_LENGTH;
      break;
    default:
      break;
    }
  }
};

class SliderBodyLenFactorAuditor : public SoDialogRealSliderAuditor
{
  PoMesh2DVec* v_MeshVecField;
public:
  SliderBodyLenFactorAuditor(PoMesh2DVec* meshVecField) : v_MeshVecField(meshVecField)
  { }

  void dialogRealSlider(SoDialogRealSlider* cpt)
  {
    v_MeshVecField->bodyLengthFactor = cpt->value.getValue();
  }
};

class BodyRadiusTypeAuditor : public SoDialogChoiceAuditor
{
  PoMesh2DVec* v_MeshVecField;
public:
  BodyRadiusTypeAuditor(PoMesh2DVec* meshVecField) : v_MeshVecField(meshVecField)
  {}

  void
  dialogChoice( SoDialogChoice* cpt )
  {
    switch ( cpt->selectedItem.getValue() )
    {
    case 0:
      v_MeshVecField->bodyRadiusType = PoMesh2DVec::CONSTANT_RADIUS;
      break;
    case 1:
      v_MeshVecField->bodyRadiusType = PoMesh2DVec::RELATIVE_RADIUS;
      break;
    default:
      break;
    }
  }
};

class SliderBodyRadiusFactorAuditor : public SoDialogRealSliderAuditor
{
  PoMesh2DVec* v_MeshVecField;
public:
  SliderBodyRadiusFactorAuditor(PoMesh2DVec* meshVecField) : v_MeshVecField(meshVecField)
  { }

  void dialogRealSlider(SoDialogRealSlider* cpt)
  {
    v_MeshVecField->bodyRadiusFactor = cpt->value.getValue();
  }
};

class BodyColoringTypeAuditor : public SoDialogChoiceAuditor
{
  PoMesh2DVec* v_MeshVecField;
public:
  BodyColoringTypeAuditor(PoMesh2DVec* meshVecField) : v_MeshVecField(meshVecField)
  {}

  void
  dialogChoice( SoDialogChoice* cpt )
  {
    switch ( cpt->selectedItem.getValue() )
    {
    case 0:
      v_MeshVecField->bodyColoringType = PoMesh2DVec::CONSTANT_COLOR;
      break;
    case 1:
      v_MeshVecField->bodyColoringType = PoMesh2DVec::MODULE_MAPPING_COLOR;
      break;
    case 2:
      v_MeshVecField->bodyColoringType = PoMesh2DVec::SCALAR_MAPPING_COLOR;
      break;
    default:
      break;
    }
  }
};

class StartArrowTypeAuditor : public SoDialogChoiceAuditor
{
  PoMesh2DVec* v_MeshVecField;
public:
  StartArrowTypeAuditor(PoMesh2DVec* meshVecField) : v_MeshVecField(meshVecField)
  {}

  void
  dialogChoice( SoDialogChoice* cpt )
  {
    switch ( cpt->selectedItem.getValue() )
    {
    case 0 : v_MeshVecField->startArrowShape = PoMesh2DVec::NO_SHAPE; break;
    case 1 : v_MeshVecField->startArrowShape = PoMesh2DVec::POINT; break;
    case 2 : v_MeshVecField->startArrowShape = PoMesh2DVec::CHEVRON; break;
    case 3 : v_MeshVecField->startArrowShape = PoMesh2DVec::TRIANGLE; break;
    case 4 : v_MeshVecField->startArrowShape = PoMesh2DVec::RECTANGLE; break;
    case 5 : v_MeshVecField->startArrowShape = PoMesh2DVec::CONE; break;
    case 6 : v_MeshVecField->startArrowShape = PoMesh2DVec::BOX; break;
    case 7 : v_MeshVecField->startArrowShape = PoMesh2DVec::SPHERE; break;
    case 8 : v_MeshVecField->startArrowShape = PoMesh2DVec::INDIRECT_CHEVRON; break;
    case 9 : v_MeshVecField->startArrowShape = PoMesh2DVec::INDIRECT_TRIANGLE; break;
    case 10: v_MeshVecField->startArrowShape = PoMesh2DVec::INDIRECT_CONE; break;
    default: break;
    }
  }
};

class StartArrowHeightTypeAuditor : public SoDialogChoiceAuditor
{
  PoMesh2DVec* v_MeshVecField;
public:
  StartArrowHeightTypeAuditor(PoMesh2DVec* meshVecField) : v_MeshVecField(meshVecField)
  {}

  void
  dialogChoice( SoDialogChoice* cpt )
  {
    switch ( cpt->selectedItem.getValue() )
    {
    case 0 : v_MeshVecField->startArrowHeightType = PoMesh2DVec::CONSTANT_HEIGHT; break;
    case 1 : v_MeshVecField->startArrowHeightType = PoMesh2DVec::RELATIVE_HEIGHT; break;
    default: break;
    }
  }
};

class SliderStartArrowHeightFactorAuditor : public SoDialogRealSliderAuditor
{
  PoMesh2DVec* v_MeshVecField;
public:
  SliderStartArrowHeightFactorAuditor(PoMesh2DVec* meshVecField) : v_MeshVecField(meshVecField)
  { }

  void dialogRealSlider(SoDialogRealSlider* cpt)
  {
    v_MeshVecField->startArrowHeightFactor = cpt->value.getValue();
  }
};

class SliderStartArrowRadiusFactorAuditor : public SoDialogRealSliderAuditor
{
  PoMesh2DVec* v_MeshVecField;
public:
  SliderStartArrowRadiusFactorAuditor(PoMesh2DVec* meshVecField) : v_MeshVecField(meshVecField)
  { }

  void dialogRealSlider(SoDialogRealSlider* cpt)
  {
    v_MeshVecField->startArrowRadiusFactor = cpt->value.getValue();
  }
};

class StartArrowColorTypeAuditor : public SoDialogChoiceAuditor
{
  PoMesh2DVec* v_MeshVecField;
public:
  StartArrowColorTypeAuditor(PoMesh2DVec* meshVecField) : v_MeshVecField(meshVecField)
  {}

  void
  dialogChoice( SoDialogChoice* cpt )
  {
    switch ( cpt->selectedItem.getValue() )
    {
    case 0 : v_MeshVecField->startArrowColoringType = PoMesh2DVec::CONSTANT_COLOR; break;
    case 1 : v_MeshVecField->startArrowColoringType = PoMesh2DVec::MODULE_MAPPING_COLOR; break;
    case 2 : v_MeshVecField->startArrowColoringType = PoMesh2DVec::SCALAR_MAPPING_COLOR; break;
    default: break;
    }
  }
};

class EndArrowTypeAuditor : public SoDialogChoiceAuditor
{
  PoMesh2DVec* v_MeshVecField;
public:
  EndArrowTypeAuditor(PoMesh2DVec* meshVecField) : v_MeshVecField(meshVecField)
  {}

  void
  dialogChoice( SoDialogChoice* cpt )
  {
    switch ( cpt->selectedItem.getValue() )
    {
    case 0 : v_MeshVecField->endArrowShape = PoMesh2DVec::NO_SHAPE; break;
    case 1 : v_MeshVecField->endArrowShape = PoMesh2DVec::POINT; break;
    case 2 : v_MeshVecField->endArrowShape = PoMesh2DVec::CHEVRON; break;
    case 3 : v_MeshVecField->endArrowShape = PoMesh2DVec::TRIANGLE; break;
    case 4 : v_MeshVecField->endArrowShape = PoMesh2DVec::RECTANGLE; break;
    case 5 : v_MeshVecField->endArrowShape = PoMesh2DVec::CONE; break;
    case 6 : v_MeshVecField->endArrowShape = PoMesh2DVec::BOX; break;
    case 7 : v_MeshVecField->endArrowShape = PoMesh2DVec::SPHERE; break;
    case 8 : v_MeshVecField->endArrowShape = PoMesh2DVec::INDIRECT_CHEVRON; break;
    case 9 : v_MeshVecField->endArrowShape = PoMesh2DVec::INDIRECT_TRIANGLE; break;
    case 10: v_MeshVecField->endArrowShape = PoMesh2DVec::INDIRECT_CONE; break;
    default: break;
    }
  }
};

class EndArrowHeightTypeAuditor : public SoDialogChoiceAuditor
{
  PoMesh2DVec* v_MeshVecField;
public:
  EndArrowHeightTypeAuditor(PoMesh2DVec* meshVecField) : v_MeshVecField(meshVecField)
  {}

  void
  dialogChoice( SoDialogChoice* cpt )
  {
    switch ( cpt->selectedItem.getValue() )
    {
    case 0 : v_MeshVecField->endArrowHeightType = PoMesh2DVec::CONSTANT_HEIGHT; break;
    case 1 : v_MeshVecField->endArrowHeightType = PoMesh2DVec::RELATIVE_HEIGHT; break;
    default: break;
    }
  }
};

class EndArrowColorTypeAuditor : public SoDialogChoiceAuditor
{
  PoMesh2DVec* v_MeshVecField;
public:
  EndArrowColorTypeAuditor(PoMesh2DVec* meshVecField) : v_MeshVecField(meshVecField)
  {}

  void
  dialogChoice( SoDialogChoice* cpt )
  {
    switch ( cpt->selectedItem.getValue() )
    {
    case 0 : v_MeshVecField->endArrowColoringType = PoMesh2DVec::CONSTANT_COLOR; break;
    case 1 : v_MeshVecField->endArrowColoringType = PoMesh2DVec::MODULE_MAPPING_COLOR; break;
    case 2 : v_MeshVecField->endArrowColoringType = PoMesh2DVec::SCALAR_MAPPING_COLOR; break;
    default: break;
    }
  }
};

class SliderEndArrowHeightFactorAuditor : public SoDialogRealSliderAuditor
{
  PoMesh2DVec* v_MeshVecField;
public:
  SliderEndArrowHeightFactorAuditor(PoMesh2DVec* meshVecField) : v_MeshVecField(meshVecField)
  { }

  void dialogRealSlider(SoDialogRealSlider* cpt)
  {
    v_MeshVecField->endArrowHeightFactor = cpt->value.getValue();
  }
};

class SliderEndArrowRadiusFactorAuditor : public SoDialogRealSliderAuditor
{
  PoMesh2DVec* v_MeshVecField;
public:
  SliderEndArrowRadiusFactorAuditor(PoMesh2DVec* meshVecField) : v_MeshVecField(meshVecField)
  { }

  void dialogRealSlider(SoDialogRealSlider* cpt)
  {
    v_MeshVecField->endArrowRadiusFactor = cpt->value.getValue();
  }
};


/*---------------------------------------------------------------------------*/
Vec2DViewer::Vec2DViewer() :
  v_Domain(NULL)
{
  strcpy(v_3DViewerTitle,"3D_mesh_viewer");
}/*---------------------------------------------------------------------------*/


void Vec2DViewer::setTitle(const char *title) {
  if (title) strcpy(v_3DViewerTitle,title);
}/*---------------------------------------------------------------------------*/


void Vec2DViewer::buildDialogBox ()
{
  SoDialogPushButton* buttonIvFile = new SoDialogPushButton();
  buttonIvFile->label.setValue( "write" );
  buttonIvFile->buttonLabel.setValue( ".iv File" );
  buttonIvFile->addAuditor( new WriteAuditor(v_Root) );
  v_Dialog->addChild( buttonIvFile  );

  SoDialogCheckBox* switchLines = new SoDialogCheckBox();
  switchLines->label.setValue( "mesh Lines" );
  switchLines->state.setValue( TRUE );
  switchLines->onString.setValue( "on" );
  switchLines->offString.setValue( "off" );
  switchLines->addAuditor( new SwitchLinesAuditor(v_MeshLinesSwitch) );
  v_Dialog->addChild( switchLines );

  SoDialogCheckBox* switchVecSkin = new SoDialogCheckBox();
  switchVecSkin->label.setValue( "vec field" );
  switchVecSkin->state.setValue( TRUE );
  switchVecSkin->onString.setValue( "on" );
  switchVecSkin->offString.setValue( "off" );
  switchVecSkin->addAuditor( new SwitchVecSkinAuditor(v_MeshVecFieldSwitch) );
  v_Dialog->addChild( switchVecSkin );

  SoDialogIntegerSlider* sliderDensity = new SoDialogIntegerSlider();
  sliderDensity->label = "Density";
  sliderDensity->min = 1;
  sliderDensity->max = 10;
  sliderDensity->value = 1;
  sliderDensity->addAuditor( new SliderDensityAuditor(v_MeshVecField) );
  v_Dialog->addChild( sliderDensity );

  static const char *elimt_type[] = { "none","too small","too long","too small or too long"};
  SoDialogComboBox* choiceElimination = new SoDialogComboBox();
  choiceElimination->label.setValue( "Type of elimination :" );
  choiceElimination->items.setValues( 0, 4, (const char**) elimt_type );
  choiceElimination->addAuditor( new ChoiceEliminationAuditor(v_MeshVecField) );
  v_Dialog->addChild( choiceElimination );

  SoDialogRealSlider* sliderMinLen = new SoDialogRealSlider();
  sliderMinLen->label = "Min length";
  sliderMinLen->min = 0.0f;
  sliderMinLen->max = 10.0f;
  sliderMinLen->value = 0.0f;
  sliderMinLen->addAuditor( new SliderMinLengthAuditor(v_MeshVecField) );
  v_Dialog->addChild( sliderMinLen );

  SoDialogRealSlider* sliderMaxLen = new SoDialogRealSlider();
  sliderMaxLen->label = "Max length";
  sliderMaxLen->min = 0.0f;
  sliderMaxLen->max = 10.0f;
  sliderMaxLen->value = 10.0f;
  sliderMaxLen->addAuditor( new SliderMaxLengthAuditor(v_MeshVecField) );
  v_Dialog->addChild( sliderMaxLen );

  SoDialogSeparator* separator1 = new SoDialogSeparator;
  v_Dialog->addChild( separator1 );

  static const char *body_type[] = { "no body","line","cylinder"};
  SoDialogComboBox* bodyType = new SoDialogComboBox();
  bodyType->label.setValue( "Body type:" );
  bodyType->items.setValues( 0, 3, (const char**) body_type );
  bodyType->addAuditor( new BodyTypeAuditor(v_MeshVecField) );
  bodyType->selectedItem = 1;
  v_Dialog->addChild( bodyType );

  static const char *body_len_type[] = { "constant length","relative length"};
  SoDialogComboBox* bodyLenType = new SoDialogComboBox();
  bodyLenType->label.setValue( "Body len type:" );
  bodyLenType->items.setValues( 0, 2, (const char**) body_len_type );
  bodyLenType->addAuditor( new BodyLenTypeAuditor(v_MeshVecField) );
  bodyLenType->selectedItem = 1;
  v_Dialog->addChild( bodyLenType );

  SoDialogRealSlider* sliderBodyLenFactor = new SoDialogRealSlider();
  sliderBodyLenFactor->label = "Body length factor";
  sliderBodyLenFactor->min = 0.5f;
  sliderBodyLenFactor->max = 3.0f;
  sliderBodyLenFactor->value = 1.0f;
  sliderBodyLenFactor->addAuditor( new SliderBodyLenFactorAuditor(v_MeshVecField) );
  v_Dialog->addChild( sliderBodyLenFactor );

  static const char *body_radius_type[] = { "constant radius","relative radius"};
  SoDialogComboBox* bodyRadiusType = new SoDialogComboBox();
  bodyRadiusType->label.setValue( "Body radius type:" );
  bodyRadiusType->items.setValues( 0, 2, (const char**) body_radius_type );
  bodyRadiusType->addAuditor( new BodyRadiusTypeAuditor(v_MeshVecField) );
  bodyRadiusType->selectedItem = 1;
  v_Dialog->addChild( bodyRadiusType );

  SoDialogRealSlider* sliderBodyRadiusFactor = new SoDialogRealSlider();
  sliderBodyRadiusFactor->label = "Body radius factor";
  sliderBodyRadiusFactor->min = 0.01f;
  sliderBodyRadiusFactor->max = 0.05f;
  sliderBodyRadiusFactor->value = 0.02f;
  sliderBodyRadiusFactor->addAuditor( new SliderBodyRadiusFactorAuditor(v_MeshVecField) );
  v_Dialog->addChild( sliderBodyRadiusFactor );

  static const char *colr_type[] = { "constant","module mapping","scalar mapping"};
  SoDialogComboBox* bodyColoringType = new SoDialogComboBox();
  bodyColoringType->label.setValue( "Body color type:" );
  bodyColoringType->items.setValues( 0, 3, (const char**) colr_type );
  bodyColoringType->addAuditor( new BodyColoringTypeAuditor(v_MeshVecField) );
  bodyColoringType->selectedItem = 0;
  v_Dialog->addChild( bodyColoringType );

  SoDialogSeparator* separator2 = new SoDialogSeparator;
  v_Dialog->addChild( separator2 );

  static const char *arrow_type[] = {
    "no_shape",
    "point",
    "chevron",
    "triangle",
    "rectangle",
    "cone",
    "box",
    "sphere",
    "indirect_chevron",
    "indirect_triangle",
    "indirect_cone"
  };
  SoDialogComboBox* arrowType = new SoDialogComboBox();
  arrowType->label.setValue( "Start arrow type:" );
  arrowType->items.setValues( 0, 11, (const char**) arrow_type );
  arrowType->addAuditor( new StartArrowTypeAuditor(v_MeshVecField) );
  arrowType->selectedItem = 0;
  v_Dialog->addChild( arrowType );

  static const char *arrow_height_type[]={"constant","relative"};
  SoDialogComboBox* arrowHeightType = new SoDialogComboBox();
  arrowHeightType->label.setValue( "Start arrow height type\n" );
  arrowHeightType->items.setValues( 0, 2, (const char**) arrow_height_type );
  arrowHeightType->addAuditor( new StartArrowHeightTypeAuditor(v_MeshVecField) );
  arrowHeightType->selectedItem = 1;
  v_Dialog->addChild( arrowHeightType );

  SoDialogRealSlider* sliderStartArrowHeightFactor = new SoDialogRealSlider();
  sliderStartArrowHeightFactor->label = "Start arrow ht factor";
  sliderStartArrowHeightFactor->min = 0.05f;
  sliderStartArrowHeightFactor->max = 0.3f;
  sliderStartArrowHeightFactor->value = 0.1f;
  sliderStartArrowHeightFactor->addAuditor( new SliderStartArrowHeightFactorAuditor(v_MeshVecField) );
  v_Dialog->addChild( sliderStartArrowHeightFactor );

  SoDialogRealSlider* sliderStartArrowRadiusFactor = new SoDialogRealSlider();
  sliderStartArrowRadiusFactor->label = "Start arrow rd factor";
  sliderStartArrowRadiusFactor->min = 0.1f;
  sliderStartArrowRadiusFactor->max = 1.0f;
  sliderStartArrowRadiusFactor->value = 0.5f;
  sliderStartArrowRadiusFactor->addAuditor( new SliderStartArrowRadiusFactorAuditor(v_MeshVecField) );
  v_Dialog->addChild( sliderStartArrowRadiusFactor );

  SoDialogComboBox* arrowColorType = new SoDialogComboBox();
  arrowColorType->label.setValue( "Start arrow color type:" );
  arrowColorType->items.setValues( 0, 3, (const char**) colr_type );
  arrowColorType->addAuditor( new StartArrowColorTypeAuditor(v_MeshVecField) );
  arrowColorType->selectedItem = 0;
  v_Dialog->addChild( arrowColorType );

  SoDialogSeparator* separator3 = new SoDialogSeparator;
  v_Dialog->addChild( separator3 );

  SoDialogComboBox* endArrowType = new SoDialogComboBox();
  endArrowType->label.setValue( "End arrow type:" );
  endArrowType->items.setValues( 0, 11, (const char**) arrow_type );
  endArrowType->addAuditor( new EndArrowTypeAuditor(v_MeshVecField) );
  endArrowType->selectedItem = 2;
  v_Dialog->addChild( endArrowType );

  SoDialogComboBox* endArrowHeightType = new SoDialogComboBox();
  endArrowHeightType->label.setValue( "End arrow height type\n" );
  endArrowHeightType->items.setValues( 0, 2, (const char**) arrow_height_type );
  endArrowHeightType->addAuditor( new EndArrowHeightTypeAuditor(v_MeshVecField) );
  endArrowHeightType->selectedItem = 1;
  v_Dialog->addChild( endArrowHeightType );

  SoDialogRealSlider* sliderEndArrowHeightFactor = new SoDialogRealSlider();
  sliderEndArrowHeightFactor->label = "End arrow ht factor";
  sliderEndArrowHeightFactor->min = 0.05f;
  sliderEndArrowHeightFactor->max = 0.3f;
  sliderEndArrowHeightFactor->value = 0.1f;
  sliderEndArrowHeightFactor->addAuditor( new SliderEndArrowHeightFactorAuditor(v_MeshVecField) );
  v_Dialog->addChild( sliderEndArrowHeightFactor );

  SoDialogRealSlider* sliderEndArrowRadiusFactor = new SoDialogRealSlider();
  sliderEndArrowRadiusFactor->label = "End arrow rd factor";
  sliderEndArrowRadiusFactor->min = 0.1f;
  sliderEndArrowRadiusFactor->max = 1.0f;
  sliderEndArrowRadiusFactor->value = 0.5f;
  sliderEndArrowRadiusFactor->addAuditor( new SliderEndArrowRadiusFactorAuditor(v_MeshVecField) );
  v_Dialog->addChild( sliderEndArrowRadiusFactor );

  SoDialogComboBox* endArrowColorType = new SoDialogComboBox();
  endArrowColorType->label.setValue( "End arrow color type:" );
  endArrowColorType->items.setValues( 0, 3, (const char**) colr_type );
  endArrowColorType->addAuditor( new EndArrowColorTypeAuditor(v_MeshVecField) );
  endArrowColorType->selectedItem = 0;
  v_Dialog->addChild( endArrowColorType );
}/*---------------------------------------------------------------------------*/

void Vec2DViewer::show(PoMeshProperty *mesh) {

   Widget my_window = SoXt::init(v_3DViewerTitle) ;
   SoDialogViz::init();
   if (my_window == NULL) exit(1) ;

   SbColor colors[5] = {SbColor(0.0,0.0,1.0), SbColor(0.0,1.0,1.0), SbColor(0.0,1.,0.), 
			SbColor(1.0,1.0,0.0), SbColor(1.0,0.0,0.0)} ;
   float val[5], dv, vmin,vmax;
   int j;

   const PbMesh *pb_mesh = mesh->getMesh();

   // define the data-mapping associated to the scalar-data at mesh-nodes
   pb_mesh->getMinValuesSet(0,vmin);
   pb_mesh->getMaxValuesSet(0,vmax);
   dv = (vmax-vmin)/4;
   val[0] = vmin; for (j=1; j<5; j++) val[j] = val[j-1]+dv;
   v_ScalarDataMapping = new PoNonLinearDataMapping2;
   v_ScalarDataMapping->value.setValues(0,5,val);
   v_ScalarDataMapping->color.setValues(0,5,colors);
   v_ScalarDataMapping->type = PoNonLinearDataMapping2::LINEAR_PER_LEVEL;

   // define the data-mapping associated to the scalar-data at mesh-nodes
   pb_mesh->getMinVecsSet(0,vmin);
   pb_mesh->getMaxVecsSet(0,vmax);
   dv = (vmax-vmin)/4;
   val[0] = vmin; for (j=1; j<5; j++) val[j] = val[j-1]+dv;
   v_ModuleDataMapping = new PoNonLinearDataMapping2;
   v_ModuleDataMapping->value.setValues(0,5,val);
   v_ModuleDataMapping->color.setValues(0,5,colors);
   v_ModuleDataMapping->type = PoNonLinearDataMapping2::LINEAR_PER_LEVEL;

   v_MeshLines = new PoMeshLines;
   v_MeshLines->valuesIndex.setValue(0);
   v_MeshLines->zValuesIndex.setValue(1);
   v_MeshLines->coloringType = PoMesh::COLOR_MAPPING;

   v_MeshVecField = new PoMesh2DVec;
   v_MeshVecField->vecsIndex.setValue(0);
   v_MeshVecField->valuesIndex.setValue(0);
   v_MeshVecField->zValuesIndex.setValue(1);
   v_MeshVecField->moduleDataMapping = v_ModuleDataMapping;

   v_MeshLinesSwitch = new SoSwitch;
   v_MeshLinesSwitch->addChild(v_MeshLines) ;
   v_MeshLinesSwitch->whichChild = SO_SWITCH_ALL;

   v_MeshVecFieldSwitch = new SoSwitch;
   v_MeshVecFieldSwitch->addChild(v_MeshVecField) ;
   v_MeshVecFieldSwitch->whichChild = SO_SWITCH_ALL;

   SoEnvironment *myEnvironment = new SoEnvironment;
   myEnvironment->ambientColor.setValue(1,1,1);
   myEnvironment->ambientIntensity.setValue(0.8F);

   v_Root = new SoSeparator ;
   v_Root->ref() ;
   v_Root->addChild(new SoPerspectiveCamera);
   v_Root->addChild(myEnvironment);
   if (v_Domain) v_Root->addChild(v_Domain);
   v_Root->addChild(mesh);
   v_Root->addChild(v_ScalarDataMapping);
   v_Root->addChild(v_MeshLinesSwitch);
   v_Root->addChild(v_MeshVecFieldSwitch);

   v_Viewer = new SoXtExaminerViewer(my_window);
   v_Viewer->setSceneGraph(v_Root);
   v_Viewer->setTitle(v_3DViewerTitle);
   v_Viewer->show();
   v_Viewer->viewAll();

   // dialog
   v_Dialog = new SoTopLevelDialog;
   v_Dialog->label = "2D vectors viewer";
   buildDialogBox();
   v_Dialog->buildDialog( my_window );
   v_Dialog->show();

   SoXt::show(my_window);
   SoXt::mainLoop();

   delete v_Viewer;
   v_Root->unref();
   SoDialogViz::finish();
   SoXt::finish();

}/*---------------------------------------------------------------------------*/


