#include <string.h>
#include <stdio.h>

#include <MeshViz/graph/PoBase.h>
#include <MeshViz/graph/PbDomain.h>
#include <MeshViz/graph/PbNonLinearDataMapping2.h>

#include <MeshViz/3Ddata/PbMesh2D.h>
#include <MeshViz/3Ddata/PoMeshLines.h>
#include <MeshViz/3Ddata/PoMesh2DVec.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/actions/SoGLRenderAction.h>
#include <Inventor/nodes/SoTransform.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoEnvironment.h>
#include <Inventor/actions/SoWriteAction.h>
#include <Inventor/nodekits/SoBaseKit.h>
#include <Inventor/SbLinear.h>

#include <Inventor/nodes/SoPerspectiveCamera.h>

#include <DialogViz/dialog/SoTopLevelDialog.h>

#define NUM_ALLOC_NAMES 20

#include <MeshViz/nodes/PoMeshProperty.h>
#include <MeshViz/nodes/PoNonLinearDataMapping2.h>
#include <MeshViz/nodes/PoMeshProperty.h>
#include <MeshViz/nodes/PoDomain.h>

class Vec2DViewer {
public:
  // constructor
  Vec2DViewer();

  // show the mesh
  void show(PoMeshProperty *mesh);
  
  // define a window title
  void setTitle(const char *title);
  
private:
  void buildDialogBox ();

  SoTopLevelDialog        *v_Dialog;
  PoMeshLines             *v_MeshLines;
  PoMesh2DVec             *v_MeshVecField;

  SoSwitch                *v_MeshLinesSwitch;
  SoSwitch                *v_MeshVecFieldSwitch;

  SoSeparator             *v_Root;
  SoXtExaminerViewer      *v_Viewer;

  char                    v_3DViewerTitle[80];

  PoDomain                *v_Domain;
  PoNonLinearDataMapping2 *v_ModuleDataMapping, *v_ScalarDataMapping;

};


