#include <string.h>
#include <stdio.h>

#include <MeshViz/graph/PoBase.h>

#include <MeshViz/nodes/PoDomain.h>
#include <MeshViz/nodes/PoNonLinearDataMapping2.h>
#include <MeshViz/nodes/PoMeshProperty.h>

#include <MeshViz/3Ddata/PbMesh2D.h>
#include <MeshViz/3Ddata/PbMesh3D.h>
#include <MeshViz/3Ddata/PoMeshSkin.h>
#include <MeshViz/3Ddata/PoMesh3DVec.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/actions/SoGLRenderAction.h>
#include <Inventor/nodes/SoTransform.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoEnvironment.h>
#include <Inventor/actions/SoWriteAction.h>
#include <Inventor/nodekits/SoBaseKit.h>
#include <Inventor/SbLinear.h>

#include <Inventor/nodes/SoPerspectiveCamera.h>

#include <DialogViz/dialog/SoTopLevelDialog.h>

#define NUM_ALLOC_NAMES 20

class Vec3DViewer {
public:
  // constructor
  Vec3DViewer();

  // show the mesh
  void show(PoMeshProperty *mesh);
  
  // define a window title
  void setTitle(const char *title);
  
private:
  void buildDialogBox ();
  
  SoTopLevelDialog        *v_Dialog;
  PoMeshSkin              *v_MeshSkin;
  PoMesh3DVec             *v_MeshVecField;

  SoSwitch                *v_MeshSkinSwitch;
  SoSwitch                *v_MeshVecFieldSwitch;

  SoSeparator             *v_Root;
  SoXtExaminerViewer      *v_Viewer;

  char                    v_3DViewerTitle[80];

  PoDomain                *v_Domain;
  PoNonLinearDataMapping2 *v_ModuleDataMapping, *v_ScalarDataMapping;

};


