// tutorial11.cxx

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoAnnotation.h>
#include <MeshViz/graph/PoArrow.h>
# include <MeshViz/graph/PbDomain.h>
# include <MeshViz/nodes/PoDomain.h>

#include <Inventor/SoWinApp.h>
int 
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;

  // Initialize MeshViz
  PoMeshViz::init() ;

  // Create the root of the scene graph
  SoAnnotation *root = new SoAnnotation;
  root->ref() ;

  // Create the arrow and set appearance
  PoArrow *myArrow = new PoArrow;
  SbVec2f points[3]= {SbVec2f(0.,0.),SbVec2f(10.,10.),SbVec2f(20.,10.)};
  myArrow->point.setValues(0,3,points);
  myArrow->endPatternType = PoArrow::DIRECT_TRIANGLE;
  myArrow->set("endApp.material","diffuseColor 1 0 0");
  myArrow->set("appearance.material", "diffuseColor 0 0 0") ;
  myArrow->patternWidth = .1F;
  myArrow->patternHeight = .075F;

  // Set the domain to define end pattern size
#ifdef USE_PB
  PbDomain myDom(0.,0.,20.,20.);
  myArrow->setDomain(&myDom);
#else
  PoDomain *myDom = new PoDomain;
  myDom->min = SbVec3f(0,0,0);
  myDom->max = SbVec3f(20,20,0);
  root->addChild(myDom);
#endif
  root->addChild(myArrow) ;
  
  SoXtPlaneViewer *viewer = new SoXtPlaneViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setBackgroundColor(SbColor(1., 1., 1.)) ;
#ifdef _WIN32
  viewer->setCursorStyle(SoWinViewer::XOR);
#endif
  viewer->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();
  return 0;
}


