//tutorial12.cxx

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoAnnotation.h>
#include <MeshViz/graph/PoCurve.h>

#include <Inventor/SoWinApp.h>
int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;
  
  // Initialize MeshViz
  PoMeshViz::init() ;

  // Create the root of the scene graph
  SoAnnotation *root = new SoAnnotation;
  root->ref() ;
  
  // Create the curve
  PoCurve *myCurve = new PoCurve;
#define N_PT 50
#define PI 3.1415F
  SbVec2f points[N_PT];
  double ang;
  int i;
  for (i=0, ang=0.; i < N_PT; i++, ang += 4.*PI/(double)N_PT)
    points[i].setValue((float)ang, (float)(6. * sin(ang)));
  myCurve->point.setValues(0,N_PT,points);
  myCurve->curveRep = PoCurve::CURVE_POLYLINE;
  myCurve->isCurveFilled = TRUE;
  myCurve->raiseFilterType = PoCurve::X_PERIOD;
  myCurve->raiseXPeriod = float(PI/3.);
  myCurve->raiseThreshold = 0.0;
  myCurve->markerFilterType = PoCurve::X_PERIOD;
  myCurve->markerXPeriod = PI;
  myCurve->set("markerApp.material", "diffuseColor [0 0 0]");
  myCurve->set("markerApp.drawStyle", "pointSize 5.0");
  myCurve->set("curvePointApp.material", "diffuseColor [1 0 0]");
  myCurve->set("curveFillingApp.material", "diffuseColor [0 0 1]");
  root->addChild(myCurve);
  
  SoXtPlaneViewer *viewer = new SoXtPlaneViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setBackgroundColor(SbColor(1., 1., 1.)) ;
#ifdef _WIN32
  viewer->setCursorStyle(SoWinViewer::XOR);
#endif
  viewer->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}


