// tutorial13.cxx

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <MeshViz/graph/PoCurve.h>
#include <MeshViz/graph/PoLinearAxis.h>
# include <MeshViz/graph/PbDomain.h>
# include <MeshViz/nodes/PoDomain.h>

#include <Inventor/SoWinApp.h>

#define PI 3.1415F
#define N_PT 50
int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;
  
  // Initialize MeshViz
  PoMeshViz::init() ;
  
  // Create the curve
  PoCurve *myCurve = new PoCurve;
  SbVec2f points[N_PT];
  double ang;
  int i;
  for (i=0, ang=0.; i < N_PT; i++, ang += 4.*PI/(double)N_PT)
    points[i].setValue((float)ang, (float)(6. * sin(ang)));
  myCurve->point.setValues(0,N_PT,points);
  myCurve->set("curvePointApp.material", "diffuseColor [1 0 0]");
  
  // Create simple automatic X and Y linear axis
  // Do not forget to set the domain if you want
  // default parameters to be correct...
  PoLinearAxis *myXAxis = new PoLinearAxis;
  myXAxis->start.setValue(SbVec3f(0.,0.,0.));
  myXAxis->end = 4.*PI;
  myXAxis->type = PoCartesianAxis::XY;
  myXAxis->set("appearance.material", "diffuseColor 0 0 0") ;
  PoLinearAxis *myYAxis = new PoLinearAxis;
  myYAxis->start.setValue(SbVec3f(0.,-6.,0.));
  myYAxis->end = 6.;
  myYAxis->type = PoCartesianAxis::YX;
  myYAxis->set("appearance.material", "diffuseColor 0 0 0") ;

  // Create the root of the scene graph
  SoSeparator *root = new SoSeparator;
  root->ref() ;

  // Define domain
#ifdef USE_PB
  PbDomain myDom(0.,-6.,4.*PI,6.);
  myXAxis->setDomain(&myDom);
  myYAxis->setDomain(&myDom);
  myCurve->setDomain(&myDom);
#else
  PoDomain *myDom = new PoDomain;
  myDom->min = SbVec3f(0,-6,0);
  myDom->max = SbVec3f(4.*PI,6.,0);
  root->addChild(myDom);
#endif
  root->addChild(myXAxis);
  root->addChild(myYAxis);
  root->addChild(myCurve);
  
  SoXtPlaneViewer *viewer = new SoXtPlaneViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setBackgroundColor(SbColor(1., 1., 1.)) ;
#ifdef _WIN32
  viewer->setCursorStyle(SoWinViewer::XOR);
#endif
  viewer->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}


