// tutorial14.cxx

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoSeparator.h>
# include <MeshViz/graph/PbDomain.h>
# include <MeshViz/nodes/PoDomain.h>
#include <MeshViz/graph/PoCurve.h>
#include <MeshViz/graph/PoGroup2Axis.h>
#include <MeshViz/graph/PoLinearAxis.h>

#define PI 3.1415F
#define N_PT 50

#include <Inventor/SoWinApp.h>
int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;

  // Initialize MeshViz
  PoMeshViz::init() ;
  
  // Create the curve
  PoCurve *myCurve = new PoCurve;
  SbVec2f points[N_PT];
  double ang;
  int i;
  for (i=0, ang=0.; i < N_PT; i++, ang += 4.*PI/(double)N_PT)
    points[i].setValue((float)ang,(float)(6. * sin(ang)));
  myCurve->point.setValues(0,N_PT,points);
  myCurve->set("curvePointApp.material", "diffuseColor [1 0 0]");
  
  // Create a group of 2 axis and edit some fields of them
  PoGroup2Axis *my2Axis = new PoGroup2Axis;
  my2Axis->start.setValue(SbVec2f(0.,-6.));
  my2Axis->end.setValue(SbVec2f(4.*PI,6.));
  my2Axis->xTitle = "Y=Sin(X)";
  my2Axis->set("appearance.material", "diffuseColor 0 0 0") ;
  PoLinearAxis *myXAxis = SO_GET_PART(my2Axis, "xAxis", PoLinearAxis) ;
  PoLinearAxis *myYAxis = SO_GET_PART(my2Axis, "yAxis", PoLinearAxis) ;
  myXAxis->step = 1.;
  myYAxis->tickSubDef = PoAxis::NUM_SUB_TICK;
  myYAxis->tickNumOrPeriod = 2;
  
  // Create the root of the scene graph
  SoSeparator *root = new SoSeparator;
  root->ref() ;
  
#ifdef USE_PB
  // Define domain
  PbDomain myDom(0.,-6.,4.*PI,6.);
  myCurve->setDomain(&myDom);
  my2Axis->setDomain(&myDom) ;
#else
  PoDomain *myDom = new PoDomain;
  myDom->min = SbVec3f(0,-6,0);
  myDom->max = SbVec3f(4.*PI,6.,0);
  root->addChild(myDom);
#endif
  root->addChild(my2Axis);
  root->addChild(myCurve);
  
  SoXtPlaneViewer *viewer = new SoXtPlaneViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setBackgroundColor(SbColor(1., 1., 1.)) ;
#ifdef _WIN32
  viewer->setCursorStyle(SoWinViewer::XOR);
#endif
  viewer->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}


