// tutorial16.cxx

#include <Inventor/SoDB.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/sensors/SoTimerSensor.h>
# include <MeshViz/graph/PbDomain.h>
# include <MeshViz/nodes/PoDomain.h>
#include <MeshViz/graph/PoCurve.h>
#include <MeshViz/graph/PoGroup2Axis.h>

#define N_PT 50
#define max(a,b) ( ((a)>(b))?(a):(b) )

#ifdef USE_PB
PbDomain myDom;
#else
PoDomain *myDom;
#endif

static PoCurve *myCurve;
static PoGroup2Axis *my2Axis;
static SbVec2f points[N_PT];
static SoTimerSensor *mySensor;
static int cur_n_pt = 0;
static void newPointCB(void *, SoSensor *);

#include <Inventor/SoWinApp.h>
int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;
  
  // Initialize MeshViz
  PoMeshViz::init() ;
  
  // Create the curve
  myCurve = new PoCurve;
  myCurve->point.setValues(0,0,points);
  myCurve->set("curvePointApp.material", "diffuseColor 1 0 0");
  
  // Create a group of 2 axis
  my2Axis = new PoGroup2Axis;
  my2Axis->xTitle = "Randomize";
  my2Axis->set("appearance.material", "diffuseColor 0 0 0") ;

  // Create the root of the scene graph
  SoSeparator *root = new SoSeparator;
  root->ref() ;

#ifdef USE_PB
  myCurve->setDomain(&myDom) ;
  my2Axis->setDomain(&myDom) ;
#else
  // Create the domain
  myDom = new PoDomain;
  root->addChild(myDom);
#endif  
  root->addChild(myCurve);
  root->addChild(my2Axis);
  
  SoXtPlaneViewer *viewer = new SoXtPlaneViewer(myWindow);

  mySensor = new SoTimerSensor(newPointCB, viewer);
  mySensor->setInterval(1.0);
  mySensor->schedule();
  
  
  viewer->setSceneGraph(root);
  viewer->setBackgroundColor(SbColor(1., 1., 1.)) ;
#ifdef _WIN32
  viewer->setCursorStyle(SoWinViewer::XOR);
#endif
  viewer->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}

static void newPointCB(void *data, SoSensor *)
{
  int i;
  float newy,ymax,x,y;
  SoXtPlaneViewer *viewer = (SoXtPlaneViewer *) data ;
  
  newy = 50.f * rand()/RAND_MAX;
  points[cur_n_pt].setValue((float)cur_n_pt,newy);
  if(cur_n_pt < N_PT - 1) 
    cur_n_pt++ ;
  else {
    cur_n_pt=0 ;
    myCurve->point.setNum(0) ;
    return ;
  }
  
  ymax = newy;
  for (i=0; i < cur_n_pt; i++) {
    points[i].getValue(x,y);
    ymax = max(ymax, y);
  }

#ifdef USE_PB
  myDom.setDomain(0,0,N_PT,ymax);
#else
  myDom->min = SbVec3f(0,0,0);
  myDom->max = SbVec3f(N_PT,ymax,0);
#endif
  my2Axis->end.setValue(SbVec2f(N_PT,ymax));
  myCurve->point.setValues(0,cur_n_pt,points);

  viewer->viewAll() ; 
}


