// tutorial17.cxx

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoTransformSeparator.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/actions/SoGetBoundingBoxAction.h>
#include <MeshViz/graph/PoCurve.h>
#include <MeshViz/graph/PoLinearAxis.h>
#include <MeshViz/graph/PoSingleHistogram.h>
# include <MeshViz/graph/PbDomain.h>
# include <MeshViz/nodes/PoDomain.h>

#define N_PT 50
#define PI 3.1315

#include <Inventor/SoWinApp.h>
int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;
  
  // Initialize MeshViz
  PoMeshViz::init() ;

  
  // Create  X common axis
  PoLinearAxis *myXAxis = new PoLinearAxis;
  myXAxis->set("appearance.material", "diffuseColor 0 0 0") ;
  myXAxis->start.setValue(SbVec3f(0.,-1.,0.));
  myXAxis->end = 13.;
  myXAxis->type = PoCartesianAxis::XY;

  // Create Y axis for the curve
  PoLinearAxis *myCurveYAxis = new PoLinearAxis;
  myCurveYAxis->start.setValue(SbVec3f(0.,-1.,0.));
  myCurveYAxis->set("appearance.material", "diffuseColor 0 0 0") ;
  myCurveYAxis->end = 1.;
  myCurveYAxis->type = PoCartesianAxis::YX;

  // Create the curve
  PoCurve *myCurve = new PoCurve;
  SbVec2f points[N_PT];
  double ang;
  int i;
  for (i=0, ang=0.; i < N_PT; i++, ang += 4.*PI/(double)N_PT)
    points[i].setValue((float)ang, (float)sin(ang));
  myCurve->point.setValues(0,N_PT,points);
  myCurve->set("curvePointApp.material", "diffuseColor [1 0 0]");

  // Create the root of the scene graph
  SoSeparator *root = new SoSeparator;
  root->ref() ;

  // Domain of the curve
#ifdef USE_PB
  PbDomain myCurveDom(0.,-1.,13.,1.);
  myXAxis->setDomain(&myCurveDom);
  myCurveYAxis->setDomain(&myCurveDom);
  myCurve->setDomain(&myCurveDom);
#else
  PoDomain *myCurveDom = new PoDomain;
  myCurveDom->min = SbVec3f(0,-1,0);
  myCurveDom->max = SbVec3f(13,1,0);
  root->addChild(myCurveDom);
#endif
  root->addChild(myXAxis);
  root->addChild(myCurveYAxis);
  root->addChild(myCurve);

  // We compute the bounding box of the first axis system
  // So we will know how to translate the second Y axis
  SoGetBoundingBoxAction myAction(SbViewportRegion(1000,1000));
  myAction.apply(root);
  float xmin,ymin,zmin,xmax,ymax,zmax;
  myAction.getBoundingBox().getBounds(xmin,ymin,zmin,xmax,ymax,zmax);

  // Create the bar chart
  PoSingleHistogram *myHist = new PoSingleHistogram;
  myHist->start.setValue(0.,0.);
  myHist->end = 13.;
  float values[13] = {1.,10.,12.,3.,-5.,15.,10.,7.,-2.,-10.,20.,3.,5.};
  myHist->value.setValues(0,13,values);
  myHist->set("appearance.material", "diffuseColor 0 0 0") ;
  
  // Create Y axis for the bar chart
  PoLinearAxis *myHistYAxis = new PoLinearAxis;
  myHistYAxis->start.setValue(SbVec3f(xmin,-10.,0.));
  myHistYAxis->set("appearance.material", "diffuseColor 0 0 0") ;
  myHistYAxis->end = 20.;
  myHistYAxis->type = PoCartesianAxis::YX;
  
  // Domain of the histogram
#ifdef USE_PB
  PbDomain myHistDom(0.,-10,13.,20.);
  myHistYAxis->setDomain(&myHistDom);
  myHist->setDomain(&myHistDom);
#else
  PoDomain *myHistDom = new PoDomain;
  myHistDom->min = SbVec3f(0,-10,0);
  myHistDom->max = SbVec3f(13,20,0);
  root->addChild(myHistDom);
#endif

  // Now we have to align horizontally the two Y axis
  SoTranslation *myTrans = new SoTranslation;
  float trans;
  trans = float((-130./30.) - (-13./2.));
  myTrans->translation.setValue(0.,-trans,0.);
  
  // Complete the scene graph (The curve will be drawn after bar chart
  // The translation should only apply to the bar chart and its Y axis
  root->addChild(myTrans);
  root->addChild(myHistYAxis);
  root->addChild(myHist);

  SoXtPlaneViewer *viewer = new SoXtPlaneViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setBackgroundColor(SbColor(1., 1., 1.)) ; 
#ifdef _WIN32
  viewer->setCursorStyle(SoWinViewer::XOR);
#endif
  viewer->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}


