// tutorial18.cxx

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoAnnotation.h>
#include <MeshViz/graph/PoCurve.h>
#include <MeshViz/graph/PoLinearAxis.h>
#include <MeshViz/graph/PoItemLegend.h>
# include <MeshViz/graph/PbDomain.h>
# include <MeshViz/nodes/PoDomain.h>

#define PI 3.1415F
#define N_PT 50

#include <Inventor/SoWinApp.h>
int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;
  
  // Initialize MeshViz
  PoMeshViz::init() ;
  
  // Create the legend
  PoItemLegend *myLegend = new PoItemLegend;
  myLegend->start.setValue(-10.,7.);
  myLegend->end.setValue(-3,2);
  myLegend->item.set1Value(0,"sin(x)");
  myLegend->item.set1Value(1,"cos(x)");
  myLegend->item.set1Value(2,"sin(x)*cos(x)");
  SbColor colors[3] = {SbColor(1., 0., 0.), 
		       SbColor(0., 1., 0.), 
		       SbColor(0., 0., 1.) };
  myLegend->boxColor.setValues(0, 3, colors) ;
  myLegend->set("backgroundApp.material", "diffuseColor 1 1 1") ;
  myLegend->set("backgroundBorderApp.material", "diffuseColor 0 0 0") ;
  myLegend->set("boxBorderApp.material", "diffuseColor 0 0 0") ;
  myLegend->set("valueTextApp.material", "diffuseColor 0 0 0") ;
  

  // Create  X  axis
  PoLinearAxis *myXAxis = new PoLinearAxis;
  myXAxis->set("appearance.material", "diffuseColor 0 0 0") ;
  myXAxis->start.setValue(SbVec3f(0.,-1.,0.));
  myXAxis->end = 4.*PI;
  myXAxis->type = PoCartesianAxis::XY;
  
  // Create Y axis 
  PoLinearAxis *myYAxis = new PoLinearAxis;
  myYAxis->set("appearance.material", "diffuseColor 0 0 0") ;
  myYAxis->start.setValue(SbVec3f(0.,-1.,0.));
  myYAxis->end = 1.;
  myYAxis->type = PoCartesianAxis::YX;
  
  // Create the curves
  double ang;
  int i;
  
  PoCurve *myCurve1 = new PoCurve;
  SbVec2f points1[N_PT];
  for (i=0, ang=0.; i < N_PT; i++, ang += 4.*PI/(double)N_PT)
    points1[i].setValue((float)ang, (float)sin(ang));
  myCurve1->point.setValues(0,N_PT,points1);
  myCurve1->set("curvePointApp.material", "diffuseColor [1 0 0]");
  
  PoCurve *myCurve2 = new PoCurve;
  SbVec2f points2[N_PT];
  for (i=0, ang=0.; i < N_PT; i++, ang += 4.*PI/(double)N_PT)
    points2[i].setValue((float)ang, (float)cos(ang));
  myCurve2->point.setValues(0,N_PT,points2);
  myCurve2->set("curvePointApp.material", "diffuseColor [0 1 0]");
  
  PoCurve *myCurve3 = new PoCurve;
  SbVec2f points3[N_PT];
  for (i=0, ang=0.; i < N_PT; i++, ang += 4.*PI/(double)N_PT)
    points3[i].setValue((float)ang, (float)(sin(ang) * cos(ang)));
  myCurve3->set("curvePointApp.material", "diffuseColor [0 0 1]");
  
  // Create the root of the scene graph
  SoAnnotation *root = new SoAnnotation;
  root->ref() ;
  root->addChild(myLegend);  

#ifdef USE_PB
  // Define domain
  PbDomain myDom(0.,-1.,4.*PI,1.);
  myXAxis->setDomain(&myDom);
  myYAxis->setDomain(&myDom);
  myCurve1->setDomain(&myDom);
  myCurve2->setDomain(&myDom);
  myCurve3->setDomain(&myDom);
#else
  PoDomain *myDom = new PoDomain;
  myDom->min = SbVec3f(0,-1,0);
  myDom->max = SbVec3f(4.*PI,1.,0);
  root->addChild(myDom);
#endif
  root->addChild(myXAxis);
  root->addChild(myYAxis);
  root->addChild(myCurve1);
  root->addChild(myCurve2);
  root->addChild(myCurve3);
  
  SoXtPlaneViewer *viewer = new SoXtPlaneViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setBackgroundColor(SbColor(1., 1., 1.)) ;
#ifdef _WIN32
  viewer->setCursorStyle(SoWinViewer::XOR);
#endif
  viewer->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}


