// tutorial19.cxx

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
# include <MeshViz/graph/PbDomain.h>
# include <MeshViz/nodes/PoDomain.h>
#include <MeshViz/graph/PoCurve3.h>
#include <MeshViz/graph/PoGroup6Axis3.h>

#define N_PT 50
#define PI 3.1415

#include <Inventor/SoWinApp.h>
int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;
  
  // Initialize MeshViz
  PoMeshViz::init() ;
  
  // Create the curve
  double ang, radius;
  int i;
  PoCurve3 *myCurve = new PoCurve3;
  SbVec3f points[N_PT];
  ang = 0;
  radius = 0.;
  for (i=0; i < N_PT; i++, ang += 6.*PI/(double)N_PT, 
	                   radius += 10./(double)N_PT)
    points[i].setValue((float)(radius * cos(ang)),
		       (float)(radius * sin(ang)),
		       (float)(2.0f *radius));
  myCurve->point.setValues(0,N_PT,points);
  myCurve->set("curvePointApp.material", "diffuseColor [1 0 0]");
  myCurve->set("curvePointApp.drawStyle", "linewidth 3.");

  // Create the group of axis
  PoGroup6Axis3 *my6Axis = new PoGroup6Axis3;
  my6Axis->set("appearance.material", "diffuseColor 0 0 0") ;
  my6Axis->start.setValue(-10.,-10.,0.);
  my6Axis->end.setValue(10.,10.,20.);
  
  // Create the root of the scene graph
  SoSeparator *root = new SoSeparator;
  root->ref() ;
  
  // Define domain of curve and its axis.
#ifdef USE_PB
  PbDomain myDom(-10.,-10.,0.,10.,10.,20.);
  myCurve->setDomain(&myDom);
  my6Axis->setDomain(&myDom);
#else
  PoDomain *myDom = new PoDomain;
  myDom->min = SbVec3f(-10.,-10.,0.);
  myDom->max = SbVec3f(10.,10.,20.);
  root->addChild(myDom);
#endif
  root->addChild(myCurve);
  root->addChild(my6Axis);

  SoXtExaminerViewer *viewer = new SoXtExaminerViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setBackgroundColor(SbColor(1., 1., 1.)) ;
#ifdef _WIN32
  viewer->setCursorStyle(SoWinViewer::XOR);
#endif
  viewer->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}


